% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1b-base-model-function.R
\name{inclusion.stages}
\alias{inclusion.stages}
\title{Inclusion relations between stage structures of two models estimated on the same dataset}
\usage{
inclusion.stages(object1, object2)
}
\arguments{
\item{object1}{first staged event tree to compare}

\item{object2}{second staged event tree to compare}
}
\value{
a list with inclusion relations between stage
structures of each variable in the model
}
\description{
Inclusion relations between stage structures of two models estimated on the same dataset
}
\details{
it computes the inclusion/exclusion/equality/diversity between the estimated stages
between the two given models, in \code{object1} and \code{object2}.
}
\examples{
mod1 <- bhc.sevt(full(PhDArticles[, 1:5], lambda = 1))
mod2 <- fbhc.sevt(full(PhDArticles[, 1:5], lambda = 1))
inclusion.stages(mod1, mod2)
}
