#' function to print and save statistics in .csv and .html formats for report_mig and report_mig_mult class
#' @param tableau A table with the following columns : No.pas,debut_pas,fin_pas,              
#' ope_dic_identifiant,lot_tax_code,lot_std_code,type_de_quantite,MESURE,CALCULE,               
#' EXPERT,PONCTUEL,Effectif_total,taux_d_echappement,coe_valeur_coefficient
#' @note this function is intended to be called from within the summary method 
#' @param time.sequence Passed from report_mig or report_mig_mult
#' @param taxa  Taxa
#' @param stage The Stage
#' @param DC  The counting device
#' @param resum A summary table generated by funstat
#' @param silent If TRUE, all messages turned off (except warnings and errors) 
#' @return No return value, called for side effects
#' @author Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
funtable = function(tableau, time.sequence, taxa, stage, DC, resum, silent) {
	annee = paste(unique(strftime(as.POSIXlt(time.sequence), "%Y")), collapse = ",")
	tableau$debut_pas <- as.character(tableau$debut_pas)
	path1 = file.path(path.expand(get("datawd", envir = envir_stacomi)), paste(DC,
					"_", taxa, "_", stage, "_", annee, ".csv", sep = ""), fsep = "/")
	path1html = file.path(path.expand(get("datawd", envir = envir_stacomi)), paste(DC,
					"_", taxa, "_", stage, "_", annee, ".html", sep = ""), fsep = "/")
	res <- tryCatch(
			write.table(tableau, file = path1, row.names = FALSE, col.names = TRUE, sep = ";")
			, error = function(e) e,
			finally =
					if (!silent) funout(gettext("Writing of %s \n", path1, domain = "R-stacomiR"))
	
	)
	
	

	res <- tryCatch(
			suppressWarnings(funhtml(data = tableau, caption = paste(DC, "_", taxa, "_",
									stage, "_", annee, ".csv", sep = ""), top = TRUE, outfile = path1html, clipboard = FALSE,
							append = FALSE, digits = 2)),
			error = function(e) e,
			finally =
					if (!silent) funout(gettextf("writing of %s\n", path1html))
	
	)	
	if (!is.null(resum)) {
		path2 = file.path(path.expand(get("datawd", envir = envir_stacomi)), paste("res",
						DC, "_", taxa, "_", stage, "_", annee, ".csv", sep = ""), fsep = "/")
		resum1 <- resum
		resum$id = rownames(resum)
		path2html = file.path(path.expand(get("datawd", envir = envir_stacomi)),
				paste("res", annee, ".html", sep = ""), fsep = "/")
		res <- tryCatch({
					write.table(resum1, path2, row.names = FALSE, col.names = TRUE, sep = ";")
					suppressWarnings(funhtml(data = resum, caption = paste("Sommes mensuelles",
											annee), top = TRUE, outfile = path2html, clipboard = FALSE, append = TRUE,
									digits = 2))
				}, error = function(e) e,
				finally ={
					if (!silent)	funout(gettextf("writing of %s\n", path2))
					if (!silent)	funout(gettextf("writing of %s\n", path2html))
				})
		if (inherits(res, "simpleError")) {
			warnings("The table could not be reported, please change the working directory datawd with options(stacomiR.path='path/to/directory'")
		}
	}
	return(invisible(NULL))
}


