% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{ggeem}
\alias{ggeem}
\alias{ggeem.default}
\alias{ggeem.eemlist}
\alias{ggeem.eem}
\alias{ggeem.parafac}
\alias{ggeem.data.frame}
\title{EEM spectra plotted with ggplot2}
\usage{
ggeem(data, fill_max = FALSE, ...)

\method{ggeem}{default}(data, fill_max = FALSE, ...)

\method{ggeem}{eemlist}(data, fill_max = FALSE, ...)

\method{ggeem}{eem}(data, fill_max = FALSE, ...)

\method{ggeem}{parafac}(data, fill_max = FALSE, ...)

\method{ggeem}{data.frame}(data, fill_max = FALSE, ...)
}
\arguments{
\item{data}{eem, eemlist, parafac or data.frame. The details are given under 'Details'}

\item{fill_max}{FALSE}

\item{...}{parameters passed on to \code{ggplot}}
}
\value{
a ggplot object
}
\description{
\code{ggeem} creates nice plots from EEM spectra of class ggplot. Plots can be modified as any ggplot by adding layers and/or elements with "+".
}
\details{
The data can be of different sources:
    eem: a single EEM pectrum is plotted
    eemlist: all spectra of the samples are plotted in one facet plot
    data.frame: a data.frame containing EEM data. Can be created by e.g. \code{as.data.frame.eem}
}
\examples{
## plotting one distinct sample
data(eem_list)
eem <- eem_extract(eem_list,c("sample6","sample7"),keep=TRUE)
ggeem(eem)
}
