% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributionFuns.R
\name{stand_t_dens}
\alias{stand_t_dens}
\title{The density function of the univariate t distribution with zero mean and unit variance}
\usage{
stand_t_dens(y, nu)
}
\arguments{
\item{y}{a numeric vector containing the values at which the density is to be evaluated.}

\item{nu}{the degrees of freedom parameter value, a numeric scalar strictly larger than two.}
}
\value{
Returns a numeric vector of the same length as \code{y} containing the density values.
}
\description{
\code{stand_t_dens} calculates the density of the univariate t distribution with zero mean and unit variance,
  described, for example, in Virolainen (2025).
}
\details{
See Virolainen (2025) and the references therein, for example, for the details of the density function of
  t-distribution with zero mean and unit variance (assume the skewness parameter value is zero to obtain the
  non-skewed version of the t-distribution).
}
\references{
\itemize{
   \item Virolainen S. 2025. Identification by non-Gaussianity in structural threshold and
      smooth transition vector autoregressive models. Unpublished working
      paper, available as arXiv:2404.19707.
 }
}
\keyword{internal}
