% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypoTests.R
\name{Rao_test}
\alias{Rao_test}
\title{Perform Rao's score test for a STVAR model}
\usage{
Rao_test(stvar)
}
\arguments{
\item{stvar}{an object of class \code{'stvar'} generated by \code{fitSTVAR} or \code{STVAR}, containing
the model specified by the null hypothesis (i.e., \strong{the constrained model}).}
}
\value{
A list with class "hypotest" containing the test results and arguments used to calculate the test.
}
\description{
\code{Rao_test} performs Rao's score test for a STVAR model
}
\details{
Tests the constraints imposed in the model given in the argument \code{stvar}.
  This implementation uses the outer product of gradients approximation in the test statistic.

  \strong{The test is based on the assumption of the standard result of asymptotic normality!}
}
\examples{
\donttest{
## These are long running examples that take approximately 10 seconds to run.

# Logistic Student's t STVAR with p=1, M=2, and the first lag of the second variable
# as the switching variable.

## Test whether the location parameter equal 1:

# The model imposing the constraint on the location parameter (parameter values
# were obtained by maximum likelihood estimation; fitSTVAR is not used here
# because the estimation is computationally demanding):
params12w <- c(0.6592583, 0.16162866, 1.7811393, 0.38876396, 0.35499367, 0.0576433,
  -0.43570508, 0.57337706, 0.16449607, -0.01910167, -0.70747014, 0.75386158, 0.3612087,
  0.00241419, 0.03202824, 1.07459924, -0.03432236, 0.14982445, 6.22717097, 8.18575651)
fit12w <- STVAR(data=gdpdef, p=1, M=2, params=params12w, weight_function="logistic",
 weightfun_pars=c(2, 1), cond_dist="Student",
 weight_constraints=list(R=matrix(c(0, 1), nrow=2), r=c(1, 0)))
fit12w

# Test the null hypothesis of the location parameter equal 1:
Rao_test(fit12w)

## Test whether the means and AR matrices are identical across the regimes:

# The model imposing the constraint on the location parameter (parameter values
# were obtained by maximum likelihood estimation; fitSTVAR is not used here
# because the estimation is computationally demanding):
params12cm <- c(0.76892423, 0.67128089, 0.30824474, 0.03530802, -0.11498402, 0.85942541,
 0.39106754, 0.0049437, 0.03897287, 1.44457723, -0.05939876, 0.20885008, 1.23568782,
 6.42128475, 7.28733557)
fit12cm <- STVAR(data=gdpdef, p=1, M=2, params=params12cm, weight_function="logistic",
 weightfun_pars=c(2, 1), parametrization="mean", cond_dist="Student",
 mean_constraints=list(1:2), AR_constraints=rbind(diag(4), diag(4)))

# Test the null hypothesis of the means and AR matrices being identical across the regimes:
Rao_test(fit12cm)
}
}
\references{
\itemize{
   \item Buse A. (1982). The Likelihood Ratio, Wald, and Lagrange Multiplier Tests: An Expository Note.
     \emph{The American Statistician}, 36(3a), 153-157.
 }
}
\seealso{
\code{\link{LR_test}}, \code{\link{Wald_test}}, \code{\link{fitSTVAR}}, \code{\link{STVAR}},
 \code{\link{diagnostic_plot}}, \code{\link{profile_logliks}}, \code{\link{Portmanteau_test}}
}
