% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liability-valuation.R
\name{valInfo.liability}
\alias{valInfo.liability}
\title{Providing Information for Insurance Liability Valuation from a marketRisk}
\usage{
\method{valInfo}{liability}(object, market.risk, standalone = NULL, ...)
}
\arguments{
\item{object}{S3 object of class liability.}

\item{market.risk}{S3 object of class marketRisk created using the constructor
\code{marketRisk}.}

\item{standalone}{S3 object of class standalone.}

\item{...}{additional arguments.}
}
\value{
A list with the following elements:
\itemize{
  \item \code{exposure}: numeric value of length one. The nominal value of the liability.
  \item \code{constant}: numeric value of length one. The constant centering the
    log-normal expression.
  \item \code{risk.factor}: a \code{data.frame} with columns:
  \itemize{
    \item \code{name}: character value. The names of the base risk
      factors.
    \item \code{id}: integer value. The position of the base risk
      factors in the covariance matrix in \code{marketRisk}.
    \item \code{scale}: numeric value. The scales associated to the
      base risk factors.
  }
}
}
\description{
\code{valInfo} is a generic S3 method for classes
  inheriting from item. It returns sufficient information for the
  creation of the valuation function of the item.
}
\seealso{
\code{\link{valInfo}}, \code{\link{liability}},
  \code{\link{marketRisk}}, \code{\link{standalone}}.
}
