% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio-base.R
\name{generateFunction.portfolio}
\alias{generateFunction.portfolio}
\title{Generate the Market Valuation Function for a Portfolio}
\usage{
\method{generateFunction}{portfolio}(object, market.risk, ...)
}
\arguments{
\item{object}{S3 object of class portfolio.}

\item{market.risk}{S3 object of class marketRisk.}

\item{...}{additional arguments.}
}
\value{
a function, the market valuation function with the following parameter:
  \itemize{
            \item \code{x}: a matrix of simulation with named columns corresponding
              exactly to the name of base-risk factors in a \code{marketRisk} keeping the
              same order or an unnamed vector of simulations keeping the same
              ordering of risk factors as in the covariance matrix
              defined in \code{marketRisk}. Please note that if the portfolio contains
              a \code{participation}, then an additional column (in the case of matrix input) named
              \code{participation} or an additional entry (in the case of vector input) should
              be provided in the last position.
          }
}
\description{
method to generate the market valuation function for a given
  portfolio and all positions (including participation if any).
}
\note{
Please note that the valuation functions here are not centered.
}
\seealso{
\code{\link{portfolio}}.
}
