% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step2.R
\name{step2}
\alias{step2}
\title{Heckman's Two-Step Method}
\usage{
step2(YS, XS, YO, XO)
}
\arguments{
\item{YS}{A binary vector indicating selection (\code{1} if observed, \code{0} otherwise).}

\item{XS}{A matrix of covariates for the selection equation.}

\item{YO}{A numeric vector representing the outcome variable of interest.}

\item{XO}{A matrix of covariates for the outcome equation.}
}
\value{
A numeric vector containing the parameter estimates from the two-step Heckman model:
\itemize{
  \item Coefficients of the selection equation (probit model).
  \item Coefficients of the outcome equation (excluding the IMR term).
  \item Estimated \code{sigma}.
  \item Estimated \code{rho}.
}
}
\description{
Estimates the parameters of the classical Heckman selection model using the two-step method.
The first step fits a probit model for the selection equation. In the second step, the inverse Mills ratio (IMR)
is included as an additional regressor in the outcome equation.
}
\details{
This function implements the two-step estimation procedure of the classical Heckman model.
In the first step, a probit model is estimated to predict the selection indicator \code{YS} using
the selection covariates \code{XS}. The IMR is calculated from this model.
In the second step, an ordinary least squares (OLS) regression of the observed outcome \code{YO} on
\code{XO} and the IMR is performed for the uncensored observations (\code{YS == 1}).

The function also calculates:
\itemize{
  \item \code{sigma}: The estimated standard deviation of the outcome equation's error term.
  \item \code{rho}: The estimated correlation between the error terms of the selection and outcome equations.
}
}
\examples{
data(MEPS2001)
attach(MEPS2001)
YS <- dambexp
XS <- cbind(age, female, educ, blhisp, totchr, ins)
YO <- lnambx
XO <- cbind(age, female, educ, blhisp, totchr, ins, income)
step2(YS, XS, YO, XO)

}
\references{
\insertAllCited{}
}
