% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_em_binning.r
\name{change_em_binning}
\alias{change_em_binning}
\title{Change population and observed length composition bins in an SS estimation
model}
\usage{
change_em_binning(dat_list, dat_file_out, bin_vector, lbin_method = NULL,
  pop_binwidth = NULL, pop_minimum_size = NULL, pop_maximum_size = NULL,
  write_file = TRUE)
}
\arguments{
\item{dat_list}{An SS data list object as read in from
\code{\link[r4ss]{SS_readdat}} in the \pkg{r4ss} package. Make sure
you select option \code{section=2}.}

\item{dat_file_out}{A string providing the path to the output SS3 \code{.dat} file.}

\item{bin_vector}{A numeric vector of new length bins to substitute into the
\code{ss3.dat} file.}

\item{lbin_method}{A numeric value of either \code{NULL, 1, 2, 3} to change
the lbin_method for the population bin. Only supports either \code{NULL, 1,
2} at the moment. \code{NULL} means to keep it unchanged.}

\item{pop_binwidth}{*Population length bin width. Only necessary for
\code{lbin_method=2}. Note that this value must be smaller than the bin
width specified in length composition data \code{len_bins} or SS3 will
fail (see notes in the SS3 manual).}

\item{pop_minimum_size}{*Population minimum length bin value. 'Only
necessary for \code{lbin_method=2}}

\item{pop_maximum_size}{*Population maximum length bin value. Only
necessary for \code{lbin_method=2}}

\item{write_file}{Should the \code{.dat} file be written? The new \code{.dat}
file will always be returned invisibly by the function. Setting
\code{write_file = FALSE} can be useful for testing. Note that you must
supply a value to the argument \code{dat_file_out}, but this argument can be
set to any arbitrary value (such as \code{NULL}) if \code{write_file =
FALSE}.}
}
\description{
\code{change_em_binning} alters the bin structure for the population and
length composition data in an SS estimation model. It is done by taking the
original length composition info from the EM \code{ss3.dat} then changing
according to the user's specification. If the data file also contails
conditional age-at-length data then these data will be re-binned as well.
}
\examples{
d <- system.file("extdata", package = "ss3sim")
f_in <- paste0(d, "/example-om/data.ss_new")
dat_list <- r4ss::SS_readdat(file = f_in, verbose = FALSE)
l <- change_em_binning(dat_list, dat_file_out = NULL, lbin_method = 1,
  bin_vector = seq(8, 30, by = 1), write_file = FALSE)
print(l$lbin_vector)
print(head(l$lencomp))

# An small example with conditional age-at-length re-binning:
f <- system.file("extdata", "models", "cod-om", "codOM.dat", package = "ss3sim")
d <- r4ss::SS_readdat(f, verbose = FALSE)

# Add catch at length data (and simplify the bin structure for this example)
olddat <- change_data(d, outfile = NULL, write_file = FALSE,
  types = c("len", "age", "cal"), fleets = 1, years = seq(2000, 2002),
  age_bins = 1:3, len_bins = 4:8)
olddat$agecomp
newdat <- change_em_binning(olddat, dat_file_out = NULL, bin_vector = c(4, 6, 8),
  lbin_method = 1, write_file = FALSE)
newdat$agecomp

# A larger conditional age-at-length re-rebinning example:
olddat <- change_data(d, outfile = NULL, write_file = FALSE,
 types = c("len", "age", "cal"), fleets = 1, years = seq(2000, 2005),
 age_bins = seq(1, 5), len_bins = round(seq(20, 30, length.out = 13), 1))

olddat$lbin_vector
head(olddat$lencomp)
head(olddat$agecomp)
newdat <- change_em_binning(olddat, dat_file_out = NULL, bin_vector = seq(20, 30, 2),
 lbin_method = 1, write_file = FALSE)
newdat$lbin_vector
head(newdat$lencomp)
newdat$agecomp
}
\author{
Kotaro Ono (length-composition rebinning), Sean Anderson
  (conditional age-at-length rebinning)
}
\seealso{
Other change functions: \code{\link{change_data}},
  \code{\link{change_e}}, \code{\link{change_f}},
  \code{\link{change_maturity}},
  \code{\link{change_retro}}, \code{\link{change_tv}}
}

