% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_srt}
\alias{read_srt}
\title{Read a subtitle file as data frame}
\usage{
read_srt(path, collapse = "\\n")
}
\arguments{
\item{path}{A path or connection to an \code{.srt} file.}

\item{collapse}{The character with which to separate subtitle lines.}
}
\value{
A data frame of subtitles.
}
\description{
Convert the SubRip file format to a tabular data frame of times and text.
}
\details{
The SubRip format is a newline-separated, non-tabular text file with groups
of subtitle text separated by a newline character and preceded by an index
and a timestamp string containing the length of the spoken subtitle text.
These components (index, time, text) can be parsed individually and combined
into a data frame of subtitle groups.
}
\examples{
# read linear text to tabular data
read_srt(srt_example("toy-story.en.srt"), " ")
}
