% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linpred.R
\name{linpred}
\alias{linpred}
\title{Unevaluated prediction expressions for models}
\usage{
linpred(mod)
}
\arguments{
\item{mod}{A supported model object.}
}
\value{
An unevaluated R call object representing the linear predictor.
}
\description{
Generate an unevaluated call corresponding to the predict step of the passed
model. The call represents the linear predictor in terms of elementary functions
on the underlying column names. Before translation into SQL, it should have a response
function applied by score_expression (which may be a no-op in the case of the
identity response).
}
\section{Warning}{

The Binomial models in glmboost return coefficients which are 1/2 the coefficients
fit by a call to glm(..., family=binomial(...)), because the response variable is
internally recoded to -1 and +1. sqlscore multiplies the returned coefficients by 2
to put them back on the same scale as glm, and adds the glmboost offset to the
intercept before multiplying.
}
\examples{
# A Gaussian GLM including factors
mod <- glm(Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width + Species,
           data=datasets::iris)
linpred(mod)

# A binomial GLM - linear predictor is unaffected
mod <- glm(Sepal.Length > 5.0 ~ Sepal.Width + Petal.Length + Petal.Width + Species,
           data=datasets::iris, family=binomial("logit"))
linpred(mod)

#With formula operators
x <- matrix(rnorm(100*20),100,20)
colnames(x) <- sapply(1:20, function(x) paste0("X", as.character(x)))
x <- as.data.frame(x)
mod <- glm(X2 ~ X3 + X5 + X15*X8, data=x)
linpred(mod)

}

