% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shypFun.01110.R
\name{shypFun.01110}
\alias{shypFun.01110}
\title{van Genuchten-Mualem Soil Hydraulic Proptery Model}
\usage{
shypFun.01110(p, h)
}
\arguments{
\item{p}{vector of the 6 van Genuchten-Mualem model parameters, the order is sensitve and has to be given as:
\tabular{lll}{
      \code{thr}\tab{residual water water content [cm cm-3]}\cr
      \code{ths}\tab{saturated water water content [cm cm-3]}\cr
      \code{alf1}\tab{van Genuchten alpha [cm-3]}\cr
      \code{n1}\tab{van Genuchten n [-]}\cr
      \code{Ks}\tab{saturated conductivity [cm d-1]}\cr
      \code{tau}\tab{exponent of \code{Se} in the capillary conductivity model, sometimes denoted in the literature as \code{l} [-]}
}}

\item{h}{pressure heads [cm] for which the corresponding retention and conductivity values are calculated.}
}
\value{
returns a \code{list} with calculations at specified \code{h}:
\item{theta}{calculated volumetric moisture content}
\item{Se}{calculated saturation}
\item{cap}{specific water capacity function}
\item{psd}{pore size distribution}
\item{Kh}{Hydraulic conductivity values}
}
\description{
van Genuchten-Mualem functions for the retention and hydraulic conductivity curves \insertCite{vanGenuchten.1980}{spsh}.
}
\details{
The function solves analytically the spec. water capacity function and integral to the capillary bundle model.
It can be extended by the Brunswick model to account for non-capillary storage and conductivity \insertCite{Weber.2019}{spsh}.
}
\examples{
p      <- c(0.1, 0.4, 0.01, 2, 100, .5)
h      <- 10^seq(-2, 6.8, length = 197)
shyp.L <- shypFun.01110(p, h)
}
\references{
\insertRef{vanGenuchten.1980}{spsh}
\insertRef{Weber.2019}{spsh}\cr
}
\author{
Tobias KD Weber , \email{tobias.weber@uni-hohenheim.de}
}
