% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUIcollections.R
\name{hrefTab}
\alias{hrefTab}
\title{Display a list of links in a row of buttons}
\usage{
hrefTab(
  label_texts,
  hrefs,
  Id = NULL,
  title = "A list of tabs",
  title_color = "#0275d8",
  bg_colors = "#337ab7",
  text_colors = "white",
  target_blank = FALSE,
  ...
)
}
\arguments{
\item{label_texts}{individual tab labels}

\item{hrefs}{individual tab links}

\item{Id}{optional element ID}

\item{title}{element title}

\item{title_color}{title color}

\item{bg_colors}{individual tab button background color, either 1 value  to apply for all of
them or specify for each of them in a vector}

\item{text_colors}{individual tab button text color, either 1 value to apply for all of
them or specify for each of them in a vector}

\item{target_blank}{bool, whether to add \code{target="_blank"} to the link?}

\item{...}{other arguments to be passed to the html element}
}
\value{
a Shiny component
}
\description{
\code{hrefTab} creates a small section of link buttons
}
\details{
\enumerate{
\item \code{label_texts}, \code{hrefs} must be the same length
\item If more than one value is provided for \code{bg_colors} or/and \code{text_colors},
the length of these 2 vectors must be the same as \code{label_texts}
\item Use \code{""} to occupy the space if you do not want a label contains a link,
e.g \code{hrefs = c("https://google.com/", "", "")}
\item If a label does not have a link, you cannot click it and there is no hovering
effects.
}
}
\examples{
if(interactive()){
    ui <- fluidPage(
        hrefTab(
            title = "Default",
            label_texts = c("Bar Plot", "PCA Plot", "Scatter Plot"),
            hrefs = c("https://google.com/", "", "")
        ),
        hrefTab(
            title = "Different background",
            label_texts = c("Bar Plot", "PCA Plot", "Scatter Plot"),
            hrefs = c("https://google.com/", "", ""),
            bg_colors = c("#eee", "orange", "green")
        ),
        hrefTab(
            title = "Different background and text colors",
            label_texts = c("Bar Plot", "Disabled", "Scatter Plot"),
            hrefs = c("https://google.com/", "", ""),
            bg_colors = c("green", "#eee", "orange"),
            text_colors = c("#caffc1", "black", "blue")
        )
    )

    server <- function(input, output, session) {

    }
    shinyApp(ui, server)
}
}
