% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sps_iterator.R
\name{sps_iterator}
\alias{sps_iterator}
\title{Iteratively draw a sequential Poisson sample}
\usage{
sps_iterator(x, ..., n = 0L, prn = NULL)
}
\arguments{
\item{x}{A positive and finite numeric vector of sizes for units in the
population (e.g., revenue for drawing a sample of businesses).}

\item{...}{Additional arguments to \code{\link[=becomes_ta]{becomes_ta()}}.}

\item{n}{A positive integer giving the initial sample size for the iterator.}

\item{prn}{A numeric vector of permanent random numbers for units in the
population, distributed uniform between 0 and 1. The default does not use
permanent random numbers, instead generating a random vector when the
function is called.}
}
\value{
A function that returns the next unit in the sample. It take a single
argument giving the sentinel value to indicate that there are no units
left to sample (default \code{NULL}).
}
\description{
Create a function that draws new units, one at a time, according to the
sequential Poisson method without replacing previously sampled units.
}
\examples{
prn <- runif(5)
s <- sps_iterator(1:5, prn = prn)
s()
s()
s()

# Same as drawing the sample with 3 units.
sps(1:5, 3, prn = prn)
}
