% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/discovery.curve.R
\name{discovery.curve}
\alias{discovery.curve}
\title{Discovery Curve}
\usage{
discovery.curve(f, max.x = sum(f * 1:length(f)), n.pts = 100, ci = 0.95,
  f0.func = Chao1, ...)
}
\arguments{
\item{f}{a vector of species frequencies where \code{f[i]} is the number of species
represented by only \code{i} samples.}

\item{max.x}{the maximum number of samples to calculate the curve for. Defaults to the
sample size of \code{f}.}

\item{n.pts}{number of points between 0 and \code{max.x} to estimate.}

\item{ci}{size of the confidence interval (0.5:1).}

\item{f0.func}{function to use to calculate f0. Can be \code{\link{Chao1}},
\code{\link{ACE}}, \code{\link{jack1}}, \code{\link{jack2}}, \code{\link{iChao1}},
or \code{\link{Swor1}}.}

\item{...}{other arguments to \code{f0.func}.}
}
\value{
a list with:
\item{f.stats}{a named vector from \code{f0.func}.}
\item{s.ind}{a \code{matrix} of S.ind estimates for each value of m along with the standard deviation of S.ind.}
\item{s.ind.ci}{a \code{matrix} of the upper and lower confidence intervals of S.ind.}
\item{ci.poly}{a \code{matrix} of points describing the ci polygon.}
\item{rarefact.line}{a \code{matrix} of points defining the rarefaction line (<= S.obs).}
\item{extrap.line}{a \code{matrix} of points defining the extrapolation line (> S.obs).}
}
\description{
Calculate the components of a species discovery curve.
}
\examples{
data(osa.old.growth)
f <- expand.freqs(osa.old.growth)
d <- discovery.curve(f, max.x = 1200)
plot(d)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Colwell, R.K., A. Chao, N.J. Gotelli, S.-Y. Lin, C.X. Mao, R.L. Chazdon,
  and J.T. Longino. 2012. Models and estimators linking individual-based and
  sample-based rarefaction, extrapolation and comparison of assemblages.
  Journal of Plant Ecology 5(1):3-21.
}
\seealso{
\code{\link{plot.discovery.curve}}
}

