% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sprunstest.R
\name{plot.sprunstest}
\alias{plot.sprunstest}
\title{Plot the empirical distribution of runs}
\usage{
\method{plot}{sprunstest}(x, ...)
}
\arguments{
\item{x}{A object of class \emph{sprunstest}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
No return value, called for side effects
}
\description{
Plot the empirical distribution of runs
}
\details{
Plot the histogram with the empirical distribution
of the runs
}
\examples{
# Example 1: Fastfood example. sf (points)
data("FastFood.sf")
x <- sf::st_coordinates(sf::st_centroid(FastFood.sf))
listw <- spdep::knearneigh(x, k = 2)
formula <- ~ Type
srq <- sp.runs.test(formula = formula, data = FastFood.sf, listw = listw, nsim = 299)
plot(srq)

# Example 2: Spain example (poligons with 0 neinghbourhood)
data("provinces_spain")
sf::sf_use_s2(FALSE)
listw <- spdep::poly2nb(as(provinces_spain,"Spatial"), queen = FALSE)
provinces_spain$Older <- cut(provinces_spain$Older, breaks = c(-Inf,19,22.5,Inf))
levels(provinces_spain$Older) = c("low","middle","high")
formula <- ~ Older
srq <- sp.runs.test(formula = formula, data = provinces_spain, listw = listw, nsim = 299)
plot(srq)
provinces_spain$Mal2Fml <- factor(provinces_spain$Mal2Fml > 100)
levels(provinces_spain$Mal2Fml) = c("men","woman")
formula <- ~ Mal2Fml
srq <- sp.runs.test(formula = formula, data = provinces_spain, listw = listw, nsim = 299)
plot(srq)
}
\seealso{
\code{\link{sp.runs.test}}.
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Antonio Páez \tab \email{paez@gmail.com} \cr
  Manuel Ruiz  \tab \email{manuel.ruiz@upct.es} \cr
  }
}
