% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_funcs.R
\name{rGRF}
\alias{rGRF}
\title{Generate a Gaussian Random Field}
\usage{
rGRF(mu = 0, gentype = 0, xlims = c(-5, 5), ylims = c(-5, 5),
  LL = 128, df = 10, nu = 0.5, theta = 1, sig = 1, pattern)
}
\arguments{
\item{mu}{Mean of the stationary GRF.}

\item{gentype}{Set to 0 for Gaussian, 1 for Chi-square. Default
is \code{gentype=0}.}

\item{xlims, ylims}{Vectors defining the
grid limits of the x-y locations over
which to compute the covariance matrix.}

\item{LL}{Length of the side of the square grid.}

\item{df}{Degrees of freedom (an integer) for the
chi-square random field when \code{gentype=1}.}

\item{nu, theta, sig}{Matern model
parameters. See \code{\link{MaternCov}} for details.}

\item{pattern}{Optionally, a point pattern
as an object of type \code{\link[spatstat]{ppp}}
containing locations within the window. The
values of the generated GRF over these
locations are returned as the marks of
the point pattern \code{pattern}.}
}
\value{
An image as an object of class \code{\link[spatstat]{im.object}},
containing the realization of the field over the grid. If
argument \code{pattern} was supplied, the return
value is now a list contaning the realization of the field as
an image, augmented by the marked point pattern
with locations in \code{pattern} and marks the field
values over these locations. This capability is illustrated
for realizations of marked point processes
conditioning on continuous marks. See
function \code{rMIPPP_cond_loc} for more details.
}
\description{
Generates Gaussian random fields
(GRFs) and related fields via transformations.
The spatial covariances are modeled using
Matern's model.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#rGRF}
}
\details{
The code of the \code{rGRF} function
uses a modification of the functions \code{\link[fields]{sim.rf}}
and \code{\link[fields]{matern.image.cov}} from the
\code{\link[fields]{fields}} package, by Douglas Nychka,
Reinhard Furrer, John Paige, and Stephan Sain.

Depending on the choice of the Matern model parameters
we might end up having trouble with the FFT giving
negative values. The code accounts for this event and
adjusts the range of values via an increasing
variable \code{incr}. If it still takes a
long time to generate the fields try increasing the
domain of observation using wider \code{xlims}
and \code{ylims}.
}
\examples{
\donttest{
#Gaussian random field as an image
GRF1=rGRF()
p<-plot_density(as.data.frame(GRF1))
p_title<-expression( paste("GRF with Matern covariances, ", theta,"=1,",mu,"=0,",nu, "=.5,",
 sigma,"=1"))
p+ggplot2::ggtitle(p_title)
#or simply use the add_title function
p+add_title("GRF with Matern model covariances", mu=0,theta=1,nu=.5,sigma=1)
#Chi-Square random field as an image
ChiSqRF=rGRF(gentype=1,df=10)
p<-plot_density(as.data.frame(ChiSqRF))
p+add_title(paste(chi^{2}," random fields with Matern model covariances for the GRFs"),
mu=0,theta=1,nu=.5,sigma=1,df=10)
#Log-Gaussian random field as an image
GRF2=rGRF()
LogGRF=exp(rGRF())
p<-plot_density(as.data.frame(LogGRF))
p+add_title("Log-Gaussian random field with Matern model covariances", mu=0,theta=1,
 nu=.5,sigma=1)}

}
\seealso{
\code{\link{MaternCov}},
\code{\link{plot_density}},
\code{\link[ggplot2]{ggtitle}},
\code{\link{add_title}}
}
\author{
Sakis Micheas
}
