% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_plots.R
\name{plot_ind}
\alias{plot_ind}
\title{Plot membership indicators}
\usage{
plot_ind(fit, burnin = floor(fit$L/10), open_new_window = FALSE)
}
\arguments{
\item{fit}{Object of class \code{damcmc_res} or \code{bdmcmc_res}.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}

\item{open_new_window}{Open a new window for the plot.}
}
\description{
The function plots the posterior means of the
membership indicators (or allocation variables)
of each point to one of the mixture components,
based on a DAMCMC fit. These are the posterior probabilities
of a point belonging to a component.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#plot_ind}
}
\examples{
\donttest{
fit <- est_mix_damcmc(pp = spatstat::redwood, m = 10)
plot_ind(fit)}

}
\seealso{
\code{\link{est_mix_damcmc}}
}
\author{
Sakis Micheas, Yuchen Wang
}
