% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse.R
\name{get_recommendations}
\alias{get_recommendations}
\title{Create a playlist-style listening experience based on seed artists, tracks and genres.}
\usage{
get_recommendations(
  limit = 20,
  market = NULL,
  seed_artists = NULL,
  seed_genres = NULL,
  seed_tracks = NULL,
  max_acousticness = NULL,
  max_danceability = NULL,
  max_duration_ms = NULL,
  max_energy = NULL,
  max_instrumentalness = NULL,
  max_key = NULL,
  max_liveness = NULL,
  max_loudness = NULL,
  max_mode = NULL,
  max_popularity = NULL,
  max_speechiness = NULL,
  max_tempo = NULL,
  max_time_signature = NULL,
  max_valence = NULL,
  min_acousticness = NULL,
  min_danceability = NULL,
  min_duration_ms = NULL,
  min_energy = NULL,
  min_instrumentalness = NULL,
  min_key = NULL,
  min_liveness = NULL,
  min_loudness = NULL,
  min_mode = NULL,
  min_popularity = NULL,
  min_speechiness = NULL,
  min_tempo = NULL,
  min_time_signature = NULL,
  min_valence = NULL,
  target_acousticness = NULL,
  target_danceability = NULL,
  target_duration_ms = NULL,
  target_energy = NULL,
  target_instrumentalness = NULL,
  target_key = NULL,
  target_liveness = NULL,
  target_loudness = NULL,
  target_mode = NULL,
  target_popularity = NULL,
  target_speechiness = NULL,
  target_tempo = NULL,
  target_time_signature = NULL,
  target_valence = NULL,
  authorization = get_spotify_access_token(),
  include_seeds_in_response = FALSE
)
}
\arguments{
\item{limit}{Optional. The target size of the list of recommended tracks. For seeds with unusually small pools or when highly
restrictive filtering is applied, it may be impossible to generate the requested number of recommended tracks. Debugging information for
such cases is available in the response. Default: 20. Minimum: 1. Maximum: 100.}

\item{market}{Optional.
An \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2 country code} or the string \code{from_token}.
Provide this parameter if you want to apply
\href{https://developer.spotify.com/documentation/general/guides/track-relinking-guide/}{Track Relinking}.
Because \code{min_*}, \code{max_*} and \code{target_*} are applied to pools before relinking,
the generated results may not precisely match the filters applied. Original, non-relinked tracks
are available via the \code{linked_from} attribute of
the \href{https://developer.spotify.com/documentation/general/guides/track-relinking-guide/}{relinked track response}.}

\item{seed_artists}{A character vector of
\href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify IDs} for seed artists. Up to 5 seed values may be provided in any combination of \code{seed_artists}, \code{seed_tracks} and \code{seed_genres}.}

\item{seed_genres}{A character vector of any genres in the set of
\href{https://developer.spotify.com/documentation/web-api/reference/browse/get-recommendations/#available-genre-seeds}{available genre seeds}. Up to 5 seed values may be provided in any combination of \code{seed_artists}, \code{seed_tracks} and \code{seed_genres}.}

\item{seed_tracks}{A character vector of
\href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify IDs} for a seed track. Up to 5 seed values may be provided in any combination of \code{seed_artists}, \code{seed_tracks} and \code{seed_genres}.}

\item{max_acousticness}{Optional. Numeric value between 0 and 1 indicating a hard ceiling on recommended tracks' acousticness.}

\item{max_danceability}{Optional. Numeric value between 0 and 1 indicating a hard ceiling on recommended tracks' danceability.}

\item{max_duration_ms}{Optional. Integer indicating a hard ceiling on recommended tracks' duration in milliseconds.}

\item{max_energy}{Optional. Numeric value between 0 and 1 indicating a hard ceiling on recommended tracks' energy.}

\item{max_instrumentalness}{Optional. Numeric value between 0 and 1 indicating a hard ceiling on recommended tracks' instrumentalness.}

\item{max_key}{Optional. Integer ranging from 1 to 12 indicating a hard ceiling on recommended tracks' key.}

\item{max_liveness}{Optional. Numeric value between 0 and 1 indicating a hard ceiling on recommended tracks' liveness.}

\item{max_loudness}{Optional. Numeric value between 0 and 1 indicating a hard ceiling on recommended tracks' loudness.}

\item{max_mode}{Optional. Integer ranging from 0 to 1 indicating a hard ceiling on recommended tracks' mode.}

\item{max_popularity}{Optional. Integer ranging between 0 and 100 indicating a hard ceiling on recommended tracks' popularity.}

\item{max_speechiness}{Optional. Numeric value between 0 and 1 indicating a hard ceiling on recommended tracks' speechiness.}

\item{max_tempo}{Optional. Numeric value indicating a hard ceiling on recommended tracks' tempo.}

\item{max_time_signature}{Optional. Integer indicating a hard ceiling on recommended tracks' time signature.}

\item{max_valence}{Optional. Numeric value between 0 and 1 indicating a hard ceiling on recommended tracks' valence.}

\item{min_acousticness}{Optional. Numeric value between 0 and 1 indicating a hard floor on recommended tracks' acousticness.}

\item{min_danceability}{Optional. Numeric value between 0 and 1 indicating a hard floor on recommended tracks' danceability.}

\item{min_duration_ms}{Optional. Integer indicating a hard floor on recommended tracks' duration in milliseconds.}

\item{min_energy}{Optional. Numeric value between 0 and 1 indicating a hard floor on recommended tracks' energy.}

\item{min_instrumentalness}{Optional. Numeric value between 0 and 1 indicating a hard floor on recommended tracks' instrumentalness.}

\item{min_key}{Optional. Integer ranging from 1 to 12 indicating a hard floor on recommended tracks' key.}

\item{min_liveness}{Optional. Numeric value between 0 and 1 indicating a hard floor on recommended tracks' liveness.}

\item{min_loudness}{Optional. Numeric value between 0 and 1 indicating a hard floor on recommended tracks' loudness.}

\item{min_mode}{Optional. Integer ranging from 0 to 1 indicating a hard floor on recommended tracks' mode.}

\item{min_popularity}{Optional. Integer ranging between 0 and 100 indicating a hard floor on recommended tracks' popularity.}

\item{min_speechiness}{Optional. Numeric value between 0 and 1 indicating a hard floor on recommended tracks' speechiness.}

\item{min_tempo}{Optional. Numeric value indicating a hard floor on recommended tracks' tempo.}

\item{min_time_signature}{Optional. Integer indicating a hard floor on recommended tracks' time signature.}

\item{min_valence}{Optional. Numeric value between 0 and 1 indicating a hard floor on recommended tracks' valence.}

\item{target_acousticness}{Optional. Numeric value between 0 and 1 indicating a target value for recommended tracks' acousticness. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_danceability}{Optional. Numeric value between 0 and 1 indicating a target value for recommended tracks' danceability. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_duration_ms}{Optional. Integer indicating a target value for recommended tracks' duration in milliseconds. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_energy}{Optional. Numeric value between 0 and 1 indicating a target value for recommended tracks' energy. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_instrumentalness}{Optional. Numeric value between 0 and 1 indicating a target value for recommended tracks' instrumentalness. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_key}{Optional. Integer ranging from 1 to 12 indicating a target value for recommended tracks' key. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_liveness}{Optional. Numeric value between 0 and 1 indicating a target value for recommended tracks' liveness. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_loudness}{Optional. Numeric value between 0 and 1 indicating a target value for recommended tracks' loudness. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_mode}{Optional. Integer ranging from 0 to 1 indicating a target value for recommended tracks' mode. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_popularity}{Optional. Integer ranging between 0 and 100 indicating a target value for recommended tracks' popularity. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_speechiness}{Optional. Numeric value between 0 and 1 indicating a target value for recommended tracks' speechiness. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_tempo}{Optional. Numeric value indicating a target value for recommended tracks' tempo. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_time_signature}{Optional. Integer indicating a target value for recommended tracks' time signature. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{target_valence}{Optional. Numeric value between 0 and 1 indicating a target value for recommended tracks' valence. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request \code{target_energy = 0.6} and \code{target_danceability = 0.8}. All target values will be weighed equally in ranking results.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}

\item{include_seeds_in_response}{Optional. Boolean for whether to include seed object in response. Defaults to \code{FALSE}.}
}
\value{
Returns a data frame of results recommendations. See the official
\href{https://developer.spotify.com/documentation/web-api/reference/#category-search}{Spotify Web API documentation} for more information.
}
\description{
All parameters are optional, but at least one of
\code{seed_artists}, \code{seed_tracks} and \code{seed_genres} must be given.
}
\examples{
\dontrun{
get_recommendations(market = 'SE', seed_genres = 'rock')
}
}
\seealso{
Other personalization functions: 
\code{\link{get_my_top_artists_or_tracks}()},
\code{\link{get_recommendations_all}()}
}
\concept{personalization functions}
