% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sport-football.R
\name{geom_football}
\alias{geom_football}
\title{This draws a football field in its standard coordinate system, with (0, 0)
being the bottom left corner of the left-most endzone. Each unit on the
coordinate system corresponds to 1 yard
Generate a ggplot2 instance containing a regulation football field for a
specified league}
\usage{
geom_football(
  league,
  full_surf = TRUE,
  rotate = FALSE,
  rotation_dir = "ccw",
  ...
)
}
\arguments{
\item{league}{The league for which to draw the surface}

\item{full_surf}{A boolean indicating whether or not to draw a full-surface
representation of the playing surface. Default: \code{TRUE}}

\item{rotate}{A boolean indicating whether or not this feature needs to be
rotated. Default: \code{FALSE}}

\item{rotation_dir}{A string indicating which direction to rotate the
feature. Default: \code{'ccw'}}

\item{...}{Additional arguments to pass to the function. These should be the
colors to pass to the \code{{league}_features_set_colors()} function,
(although the colors are defined in the rule book) or units with which to
draw the plot}
}
\value{
A ggplot2 instance with a full-surface representation of a football
field
}
\description{
This draws a football field in its standard coordinate system, with (0, 0)
being the bottom left corner of the left-most endzone. Each unit on the
coordinate system corresponds to 1 yard
Generate a ggplot2 instance containing a regulation football field for a
specified league
}
\examples{
geom_football(league = "NFL")
geom_football(league = "NCAA", rotate = TRUE, rotation_dir = "ccw")
}
