% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R, R/predict_glm.R
\name{predict.spmodel}
\alias{predict.spmodel}
\alias{predict.splm}
\alias{predict.spautor}
\alias{predict.splm_list}
\alias{predict.spautor_list}
\alias{predict.splmRF}
\alias{predict.spautorRF}
\alias{predict.splmRF_list}
\alias{predict.spautorRF_list}
\alias{predict.spglm}
\alias{predict.spgautor}
\alias{predict.spglm_list}
\alias{predict.spgautor_list}
\title{Model predictions (Kriging)}
\usage{
\method{predict}{splm}(
  object,
  newdata,
  se.fit = FALSE,
  scale = NULL,
  df = Inf,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  type = c("response", "terms"),
  local,
  terms = NULL,
  ...
)

\method{predict}{spautor}(
  object,
  newdata,
  se.fit = FALSE,
  scale = NULL,
  df = Inf,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  type = c("response", "terms"),
  local,
  terms = NULL,
  ...
)

\method{predict}{splm_list}(
  object,
  newdata,
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  local,
  ...
)

\method{predict}{spautor_list}(
  object,
  newdata,
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  local,
  ...
)

\method{predict}{splmRF}(object, newdata, local, ...)

\method{predict}{spautorRF}(object, newdata, local, ...)

\method{predict}{splmRF_list}(object, newdata, local, ...)

\method{predict}{spautorRF_list}(object, newdata, local, ...)

\method{predict}{spglm}(
  object,
  newdata,
  type = c("link", "response", "terms"),
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  dispersion = NULL,
  terms = NULL,
  local,
  var_correct = TRUE,
  newdata_size,
  ...
)

\method{predict}{spgautor}(
  object,
  newdata,
  type = c("link", "response", "terms"),
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  dispersion = NULL,
  terms = NULL,
  local,
  var_correct = TRUE,
  newdata_size,
  ...
)

\method{predict}{spglm_list}(
  object,
  newdata,
  type = c("link", "response"),
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  newdata_size,
  level = 0.95,
  local,
  var_correct = TRUE,
  ...
)

\method{predict}{spgautor_list}(
  object,
  newdata,
  type = c("link", "response"),
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  newdata_size,
  level = 0.95,
  local,
  var_correct = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted model object.}

\item{newdata}{A data frame or \code{sf} object in which to
look for variables with which to predict. If a data frame, \code{newdata}
must contain all variables used by \code{formula(object)} and all variables
representing coordinates. If an \code{sf} object, \code{newdata} must contain
all variables used by \code{formula(object)} and coordinates are obtained
from the geometry of \code{newdata}. If omitted, missing data from the
fitted model object are used.}

\item{se.fit}{A logical indicating if standard errors are returned.
The default is \code{FALSE}.}

\item{scale}{A numeric constant by which to scale the regular standard errors and intervals.
Similar to but slightly different than \code{scale} for \code{\link[stats:predict.lm]{stats::predict.lm()}}, because
predictions form a spatial model may have different residual variances for each
observation in \code{newdata}. The default is \code{NULL}, which returns
the regular standard errors and intervals.}

\item{df}{Degrees of freedom to use for confidence or prediction intervals
(ignored if \code{scale} is not specified). The default is \code{Inf}.}

\item{interval}{Type of interval calculation. The default is \code{"none"}.
Other options are \code{"confidence"} (for confidence intervals) and
\code{"prediction"} (for prediction intervals).}

\item{level}{Tolerance/confidence level. The default is \code{0.95}.}

\item{type}{The prediction type, either on the response scale, link scale (only for
\code{spglm()} or \code{spgautor()} model objects), or terms scale.}

\item{local}{A optional logical or list controlling the big data approximation. If omitted, \code{local}
is set to \code{TRUE} or \code{FALSE} based on the observed data sample size (i.e., sample size of the fitted
model object) -- if the sample size exceeds 10,000, \code{local} is
set to \code{TRUE}, otherwise it is set to \code{FALSE}. This default behavior
occurs because main computational
burden of the big data approximation depends almost exclusively on the
observed data sample size, not the number of predictions desired
(which we feel is not intuitive at first glance).
If \code{local} is \code{FALSE}, no big data approximation
is implemented. If a list is provided, the following arguments detail the big
data approximation:
\itemize{
\item \code{method}: The big data approximation method. If \code{method = "all"},
all observations are used and \code{size} is ignored. If \code{method = "distance"},
the \code{size} data observations closest (in terms of Euclidean distance)
to the observation requiring prediction are used.
If \code{method = "covariance"}, the \code{size} data observations
with the highest covariance with the observation requiring prediction are used.
If random effects and partition factors are not used in estimation and
the spatial covariance function is monotone decreasing,
\code{"distance"} and \code{"covariance"} are equivalent. The default
is \code{"covariance"}. Only used with models fit using \code{\link[=splm]{splm()}} or \code{\link[=spglm]{spglm()}}.
\item \code{size}: The number of data observations to use when \code{method}
is \code{"distance"} or \code{"covariance"}. The default is 100. Only used
with models fit using \code{\link[=splm]{splm()}} or \code{\link[=spglm]{spglm()}}.
\item \code{parallel}: If \code{TRUE}, parallel processing via the
parallel package is automatically used. This can significantly speed
up computations even when \code{method = "all"} (i.e., no big data
approximation is used), as predictions
are spread out over multiple cores. The default is \code{FALSE}.
\item \code{ncores}: If \code{parallel = TRUE}, the number of cores to
parallelize over. The default is the number of available cores on your machine.
}
When \code{local} is a list, at least one list element must be provided to
initialize default arguments for the other list elements.
If \code{local} is \code{TRUE}, defaults for \code{local} are chosen such
that \code{local} is transformed into
\code{list(size = 100, method = "covariance", parallel = FALSE)}.}

\item{terms}{If \code{type} is \code{"terms"}, the type of terms to be returned,
specified via either numeric position or name. The default is all terms are included.}

\item{...}{Other arguments. Only used for models fit using \code{splmRF()}
or \code{spautorRF()} where \code{...} indicates other
arguments to \code{ranger::predict.ranger()}.}

\item{dispersion}{The dispersion of assumed when computing the prediction standard errors
for \code{spglm()} or \code{spgautor()} model objects when \code{family}
is \code{"nbinomial"}, \code{"beta"}, \code{"Gamma"}, or \code{"inverse.gaussian"}.
If omitted, the model object dispersion parameter is used.}

\item{var_correct}{A logical indicating whether to return the corrected prediction
variances when predicting via models fit using \code{spglm()} or \code{spgautor()}. The default is
\code{TRUE}.}

\item{newdata_size}{The \code{size} value for each observation in \code{newdata}
used when predicting for the binomial family.}
}
\value{
For \code{splm} or \code{spautor} objects, if \code{se.fit} is \code{FALSE}, \code{predict()} returns
a vector of predictions or a matrix of predictions with column names
\code{fit}, \code{lwr}, and \code{upr} if \code{interval} is \code{"confidence"}
or \code{"prediction"}. If \code{se.fit} is \code{TRUE}, a list with the following components is returned:
\itemize{
\item \code{fit}: vector or matrix as above
\item \code{se.fit}: standard error of each fit
}

For \code{splm_list} or \code{spautor_list} objects, a list that contains relevant quantities for each
list element.

For \code{splmRF} or \code{spautorRF} objects, a vector of predictions. For \code{splmRF_list}
or \code{spautorRF_list} objects, a list that contains relevant quantities for each list element.
}
\description{
Predicted values and intervals based on a fitted model object.
}
\details{
For \code{splm} and \code{spautor} objects, the (empirical) best linear unbiased predictions (i.e., Kriging
predictions) at each site are returned when \code{interval} is \code{"none"}
or \code{"prediction"} alongside standard errors. Prediction intervals
are also returned if \code{interval} is \code{"prediction"}. When
\code{interval} is \code{"confidence"}, the estimated mean is returned
alongside standard errors and confidence intervals for the mean. For \code{splm_list}
and \code{spautor_list} objects, predictions and associated intervals and standard errors are returned
for each list element.

For \code{splmRF} or \code{spautorRF} objects, random forest spatial residual
model predictions are computed by combining the random forest prediction with
the (empirical) best linear unbiased prediction for the residual. Fox et al. (2020)
call this approach random forest regression Kriging. For \code{splmRF_list}
or \code{spautorRF} objects,
predictions are returned for each list element.
}
\examples{
spmod <- splm(sulfate ~ 1,
  data = sulfate,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
predict(spmod, sulfate_preds)
predict(spmod, sulfate_preds, interval = "prediction")
augment(spmod, newdata = sulfate_preds, interval = "prediction")
\donttest{
sulfate$var <- rnorm(NROW(sulfate)) # add noise variable
sulfate_preds$var <- rnorm(NROW(sulfate_preds)) # add noise variable
sprfmod <- splmRF(sulfate ~ var, data = sulfate, spcov_type = "exponential")
predict(sprfmod, sulfate_preds)
}
\donttest{
spgmod <- spglm(presence ~ elev * strat,
  family = "binomial",
  data = moose,
  spcov_type = "exponential"
)
predict(spgmod, moose_preds)
predict(spgmod, moose_preds, interval = "prediction")
augment(spgmod, newdata = moose_preds, interval = "prediction")
}
}
\references{
Fox, E.W., Ver Hoef, J. M., & Olsen, A. R. (2020). Comparing spatial
regression to random forests for large environmental data sets.
\emph{PloS one}, 15(3), e0229509.
}
