% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loocv.R
\name{loocv}
\alias{loocv}
\alias{loocv.splm}
\title{Perform leave-one-out cross validation}
\usage{
loocv(object, ...)

\method{loocv}{splm}(object, cv_predict = FALSE, se.fit = FALSE, local, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{cv_predict}{A logical indicating whether the leave-one-out fitted values
should be returned. Defaults to \code{FALSE}.}

\item{se.fit}{A logical indicating whether the leave-one-out
prediction standard errors should be returned. Defaults to \code{FALSE}.}

\item{local}{A list or logical. If a list, specific list elements described
in \code{\link[=predict.spmodel]{predict.spmodel()}} control the big data approximation behavior.
If a logical, \code{TRUE} chooses default list elements for the list version
of \code{local} as specified in \code{\link[=predict.spmodel]{predict.spmodel()}}. Defaults to \code{FALSE},
which performs exact computations.}
}
\value{
If \code{cv_predict = FALSE} and \code{se.fit = FALSE},
a numeric vector indicating the mean-squared-prediction
leave-one-out cross validation error. If \code{cv_predict = TRUE} or \code{se.fit = TRUE},
a list with elements: \code{mspe}, a numeric vector indicating the mean-squared-prediction
leave-one-out cross validation error; \code{cv_predict}, a numeric vector
with leave-one-out predictions for each observation (if \code{cv_predict = TRUE});
and \code{se.fit}, a numeric vector with leave-one-out prediction standard
errors for each observation (if \code{se.fit = TRUE}).
}
\description{
Perform leave-one-out cross validation with options for computationally
efficient approximations for big data.
}
\details{
Each observation is held-out from the data set and the remaining data
are used to make a prediction for the held-out observation. This is compared
to the true value of the observation and a mean-squared error is computed
across all observations. The lower the mean squared error, the better the
model fit (according to the leave-one-out criterion).
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
loocv(spmod)
loocv(spmod, cv_predict = TRUE, se.fit = TRUE)
}
