% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concat.split.R
\name{concat.split.compact}
\alias{concat.split.compact}
\title{Split Concatenated Cells into a Condensed Format}
\usage{
concat.split.compact(data, split.col, sep = ",", drop = FALSE,
  fixed = TRUE, ...)
}
\arguments{
\item{data}{The input \code{data.frame} or \code{data.table}.}

\item{split.col}{The column that need to be split.}

\item{sep}{The character separating each value.}

\item{drop}{Logical. Should the original variable be dropped? Defaults to
\code{FALSE}.}

\item{fixed}{Logical. Should the split character be treated as a fixed
pattern (\code{TRUE}) or a regular expression (\code{FALSE})? Defaults to \code{TRUE}.}

\item{\dots}{optional arguments to pass to \code{cSplit}.}
}
\value{
A \code{data.table}.
}
\description{
The default splitting method for \code{concat.split}. Formerly based on
\code{\link[=read.concat]{read.concat()}} but presently a simple wrapper around \code{\link[=cSplit]{cSplit()}}.
}
\note{
THIS FUNCTION IS DEPRECATED AND WILL BE REMOVED FROM LATER VERSIONS OF
"SPLITSTACKSHAPE". It no longer does anything different from \code{\link[=cSplit]{cSplit()}}. It is
recommended that you transition your code to the \code{cSplit} function instead.
}
\examples{

\dontrun{
temp <- head(concat.test)
concat.split.compact(temp, "Likes")
concat.split.compact(temp, 4, ";")

## Extra arguments to cSplit
concat.split.compact(temp, "Siblings", drop = TRUE, stripWhite = TRUE)
}

}
\seealso{
\code{\link[=read.concat]{read.concat()}}, \code{\link[=cSplit]{cSplit()}}
}
\author{
Ananda Mahto
}
