% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splash.R
\name{quick_run}
\alias{quick_run}
\title{Calculate daily soil moisture and runoff}
\usage{
quick_run(lat, elv, n, y, wn, sf, tc, pn, kCw = 1.05, kWm = 150)
}
\arguments{
\item{lat}{double, decimal degrees.}

\item{elv}{double, elevation, m A.S.L.
Default: \eqn{0}.}

\item{n}{double, day of year.}

\item{y}{double, year.
Default: \eqn{0}.}

\item{sf}{double, fraction of sunshine hours.
Default: \eqn{1}.}

\item{tc}{double, mean daily air temperature, degrees C.
Default: \eqn{23.0}.}

\item{pn}{double, daily precipitation, mm/day.}

\item{kCw}{double, supply constant, mm/hr.
Default: \eqn{1.05} (Federer, 1982)}

\item{kWm}{double, soil moisture capacity, mm.
Default: \eqn{150} (Cramer-Prentice, 1988)}
}
\value{
Returns daily soil moisture and runoff.
}
\description{
Calculate daily soil moisture and runoff
}
\references{
Cramer, W. and Prentice, I.C., 1988. Simulation of regional soil moisture
deficits on a European scale. Norsk Geografisk Tidsskrift - Norwegian Journal
of Geography, 42(2-3), pp.149–151. \doi{10.1080/00291958808552193}

Federer, C.A., 1982. Transpirational supply and demand: plant, soil, and
atmospheric effects evaluated by simulation. Water Resources Research, 18(2),
pp.355-362. \doi{10.1029/WR018i002p00355}
}
\keyword{internal}
