% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zDepricated_3_visualize.r
\name{play_manual_tour}
\alias{play_manual_tour}
\title{Animate a manual tour. superseded}
\usage{
play_manual_tour(
  basis = NULL,
  data,
  manip_var,
  theta = NULL,
  phi_min = 0,
  phi_max = 0.5 * pi,
  angle = 0.05,
  render_type = render_plotly,
  ...
)
}
\arguments{
\item{basis}{A (p, d) orthonormal numeric matrix.
The linear combination the original variables contribute to projection space.
Defaults to NULL, generating a random basis.}

\item{data}{(n, p) dataset to project, consisting of numeric variables.}

\item{manip_var}{Integer column number or string exact column name of the.
variable to manipulate. Required, no default.}

\item{theta}{Angle in radians of "in-plane" rotation, on the xy plane of the
reference frame. Defaults to theta of the basis for a radial tour.}

\item{phi_min}{Minimum value phi should move to. Phi is angle in radians of
the "out-of-plane" rotation, the z-axis of the reference frame.
Required, defaults to 0.}

\item{phi_max}{Maximum value phi should move to. Phi is angle in radians of
the "out-of-plane" rotation, the z-axis of the reference frame.
Required, defaults to pi/2.}

\item{angle}{Target distance (in radians) between steps. Defaults to .05.}

\item{render_type}{Which graphics to render to. Defaults to render_plotly,}

\item{...}{Optionally pass additional arguments to \code{render_} and the
function used in \code{render_type}.}
}
\value{
An animation of a radial tour.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}, see \code{\link{ggtour}}.
Performs the a manual tour and returns an animation of \code{render_type}.
For use with \code{tourr::save_history()} tour paths see \code{play_tour_path()}.
}
\examples{
library(spinifex)
message("It's suggested to switch to the proto api, see `?ggtour` to get started.")

## Setup
dat_std <- scale_sd(wine[, 2:6])
clas    <- wine$Type
bas     <- basis_pca(dat_std)
mv      <- manip_var_of(bas)

\dontrun{
suppressWarnings(
  play_manual_tour(basis = bas, data = dat_std, manip_var = mv)
)

suppressWarnings(
  play_manual_tour(
    basis = bas, data = dat_std, manip_var = mv,
    theta = .5 * pi, axes = "right", fps = 5,
    angle = .08, phi_min = 0, phi_max = 2 * pi,
    aes_args = list(color = clas, shape = clas),
    identity_args = list(size = 1.5, alpha = .7),
    ggproto = list(ggplot2::theme_void(), ggplot2::ggtitle("My title")),
    render_type = render_gganimate)
)
## Saving output may require additional setup
if(FALSE){ ## Don't accidentally save file
  ## Export plotly .html widget
  play_manual_tour(basis = bas, data = dat_std, manip_var = 6,
                   render_type = render_plotly,
                   html_filename = "myRadialTour.html")
  
  ## Export gganimate .gif
  play_manual_tour(basis = bas, data = dat_std, manip_var = 1,
                   render_type = render_gganimate,
                   gif_filename = "myRadialTour.gif", gif_path = "./output")
}
}
}
\seealso{
\code{\link{render_}} For arguments to pass into \code{...}.
}
