% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{basis_olda}
\alias{basis_olda}
\title{The basis of Orthogonal Linear Discriminant Analysis (OLDA)}
\usage{
basis_olda(data, class, d = 2)
}
\arguments{
\item{data}{Numeric matrix or data.frame of the observations, coerced to matrix.}

\item{class}{The class for each observation, coerced to a factor.}

\item{d}{Number of dimensions in the projection space.}
}
\value{
A numeric matrix, an orthogonal basis that best distinguishes the
group means of \code{class}.
}
\description{
Orthogonal LDA (OLDA) is an extension of classical LDA where the discriminant
vectors are orthogonal to each other.
}
\examples{
dat_std <- scale_sd(wine[, 2:6])
clas    <- wine$Type
basis_olda(data = dat_std, class = clas)
}
\references{
Ye J (2005). "Characterization of a Family of Algorithms for Generalized
Discriminant Analysis on Undersampled Problems." J. Mach. Learn. Res.,
6, 483-502. ISSN 1532-4435.
}
\seealso{
\code{\link[Rdimtools:do.olda]{Rdimtools::do.olda}}

Other basis producing functions: 
\code{\link{basis_guided}()},
\code{\link{basis_half_circle}()},
\code{\link{basis_odp}()},
\code{\link{basis_onpp}()},
\code{\link{basis_pca}()}
}
\concept{basis producing functions}
