% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zDepricated_3_visualize.r
\name{view_frame}
\alias{view_frame}
\title{Plot a single frame of a manual tour.}
\usage{
view_frame(
  basis = NULL,
  data = NULL,
  manip_var = NULL,
  theta = 0,
  phi = 0,
  basis_label = abbreviate(row.names(basis), 3),
  rescale_data = FALSE,
  ...
)
}
\arguments{
\item{basis}{A (p, d) dim orthonormal numeric matrix.
Defaults to NULL, giving a random basis.}

\item{data}{A (n, p) dataset to project, consisting of numeric variables.}

\item{manip_var}{Optional, number of the variable to rotate.
If NULL, theta and phi must be 0 as is no manip space to rotate.}

\item{theta}{Angle in radians of "in-projection plane" rotation,
on the xy plane of the reference frame. Defaults to 0, no rotation.}

\item{phi}{Angle in radians of the "out-of-projection plane" rotation, into
the z-direction of the axes. Defaults to 0, no rotation.}

\item{basis_label}{Optional, character vector of \code{p} length, add name to the axes
in the frame, defaults to 3 letter abbreviation of the original variable names.}

\item{rescale_data}{When TRUE scales the data to between 0 and 1.
Defaults to FALSE.}

\item{...}{Optionally pass additional arguments to the \code{proto_default} for
projection point aesthetics;}
}
\value{
A ggplot object of the rotated projection.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}, see \code{\link{ggtour}}.
Projects the specified rotation as a 2D ggplot object. One static frame of
manual tour. Useful for providing user-guided interaction.
}
\examples{
## Setup
dat_std <- scale_sd(wine[, 2:6])
clas <- wine$Type
bas <- basis_pca(dat_std)
mv <- manip_var_of(bas)

## Minimal example
\dontrun{
view_frame(basis = bas)

## Typical example
view_frame(basis = bas, data = dat_std, manip_var = mv, axes = "left")

## Full example
rtheta <- runif(1, 0, 2 * pi)
rphi   <- runif(1, 0, 2 * pi)
view_frame(basis = bas, data = dat_std, manip_var = mv,
           theta = rtheta, phi = rphi, basis_label = paste0("MyNm", 1:ncol(dat_std)), 
           aes_args = list(color = clas, shape = clas),
           identity_args = list(size = 1.5, alpha = .7))}
}
\seealso{
\code{\link{proto_default}} For arguments to pass into \code{...}.
}
