% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_visualize.r
\name{oblique_frame}
\alias{oblique_frame}
\title{Plot a single frame of a manual tour}
\usage{
oblique_frame(
  basis = NULL,
  data = NULL,
  manip_var = NULL,
  theta = 0,
  phi = 0,
  lab = NULL,
  rescale_data = FALSE,
  ...
)
}
\arguments{
\item{basis}{A (p, d) dim orthonormal numeric matrix.
Defaults to NULL, giving a random basis.}

\item{data}{A  (n, p) dataset to project, consisting of numeric variables.}

\item{manip_var}{Number of the variable to rotate.}

\item{theta}{Angle in radians of "in-projection plane" rotation,
on the xy plane of the reference frame. Defaults to 0, no rotation.}

\item{phi}{Angle in radians of the "out-of-projection plane" rotation, into
the z-direction of the axes. Defaults to 0, no rotation.}

\item{lab}{Optionally, provide a character vector of length p (or 1)
to label the variable contributions to the axes, Default NULL,
results in a 3 character abbreviation of the variable names.}

\item{rescale_data}{When TRUE scales the data to between 0 and 1.
Defaults to FALSE.}

\item{...}{Optionally pass additional arguments \code{render_}.
Especially for aesthetic mappings like col, pch, cex, and alpha.}
}
\value{
A ggplot object of the rotated projection.
}
\description{
Projects the specified rotation as a 2D ggplot object. One static frame of
manual tour. Useful for providing user-guided interaction.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[,1:6])
rb       <- tourr::basis_random(n = ncol(flea_std))
theta    <- runif(1, 0, 2*pi)
phi      <- runif(1, 0, 2*pi)

oblique_frame(data = flea_std, basis = rb, manip_var = 4, theta, phi)

oblique_frame(data = flea_std, basis = rb, manip_var = 4,
              theta = 0, phi = 1,
              lab = paste0("MyNm", 3:8), rescale_data = TRUE)
}
