/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.office.OdfOfficeDrawing;

public class OdfGraphicsDocument
extends OdfDocument {
    private static String EMPTY_GRAPHICS_DOCUMENT_PATH = "/OdfGraphicsDocument.odg";
    private static OdfDocument.Resource EMPTY_GRAPHICS_DOCUMENT_RESOURCE = new OdfDocument.Resource(EMPTY_GRAPHICS_DOCUMENT_PATH);

    public static OdfGraphicsDocument newGraphicsDocument() throws Exception {
        return (OdfGraphicsDocument)OdfDocument.loadTemplate(EMPTY_GRAPHICS_DOCUMENT_RESOURCE);
    }

    public static OdfGraphicsDocument newGraphicsTemplateDocument() throws Exception {
        OdfGraphicsDocument doc = (OdfGraphicsDocument)OdfDocument.loadTemplate(EMPTY_GRAPHICS_DOCUMENT_RESOURCE);
        doc.changeMode(OdfMediaType.GRAPHICS_TEMPLATE);
        return doc;
    }

    protected OdfGraphicsDocument() {
    }

    public OdfOfficeDrawing getContentRoot() throws Exception {
        return super.getContentRoot(OdfOfficeDrawing.class);
    }

    public void changeMode(OdfMediaType type) {
        this.setMediaType(type.getOdfMediaType());
        this.getPackage().setMediaType(type.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType {
        GRAPHICS(OdfDocument.OdfMediaType.GRAPHICS),
        GRAPHICS_TEMPLATE(OdfDocument.OdfMediaType.GRAPHICS_TEMPLATE);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        public String toString() {
            return this.mMediaType.toString();
        }

        public OdfDocument.OdfMediaType getOdfMediaType() {
            return this.mMediaType;
        }

        public String getName() {
            return this.mMediaType.getName();
        }

        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

