/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CGridPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.split.SplitDockPerspective;

public class CWorkingPerspective
extends CGridPerspective {
    private boolean autoUnset = false;

    public CWorkingPerspective(String id) {
        super(id, true);
    }

    public void setAutoUnset(boolean autoUnset) {
        this.autoUnset = autoUnset;
    }

    public boolean isAutoUnset() {
        return this.autoUnset;
    }

    protected CGridPerspective.CommonSplitDockPerspective create() {
        CGridPerspective.CommonSplitDockPerspective result = super.create();
        result.addListener(new SplitDockPerspective.EntryListener(){

            public void removed(SplitDockPerspective.Entry parent, SplitDockPerspective.Entry child) {
                if (CWorkingPerspective.this.isAutoUnset()) {
                    CWorkingPerspective.this.remove(child);
                }
            }

            public void added(SplitDockPerspective.Entry parent, SplitDockPerspective.Entry child) {
                CWorkingPerspective.this.add(child);
            }

            public void modified(SplitDockPerspective.Leaf leaf, PerspectiveDockable oldDockable, PerspectiveDockable newDockable) {
                if (oldDockable != null && CWorkingPerspective.this.isAutoUnset()) {
                    CWorkingPerspective.this.remove(oldDockable);
                }
                if (newDockable != null) {
                    CWorkingPerspective.this.add(newDockable);
                }
            }
        });
        return result;
    }

    private void remove(SplitDockPerspective.Entry child) {
        if (child != null) {
            if (child.asNode() != null) {
                this.remove(child.asNode().getChildA());
                this.remove(child.asNode().getChildB());
            } else {
                PerspectiveDockable dockable = child.asLeaf().getDockable();
                if (dockable != null) {
                    this.remove(dockable);
                }
            }
        }
    }

    private void remove(PerspectiveDockable dockable) {
        PerspectiveStation station;
        CDockablePerspective cdockable;
        if (dockable instanceof CommonElementPerspective && (cdockable = ((CommonElementPerspective)((Object)dockable)).getElement().asDockable()).getWorkingArea() == this) {
            cdockable.setWorkingArea(null);
        }
        if ((station = dockable.asStation()) != null) {
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.remove(station.getDockable(i));
            }
        }
    }

    private void add(SplitDockPerspective.Entry child) {
        if (child != null) {
            if (child.asNode() != null) {
                this.add(child.asNode().getChildA());
                this.add(child.asNode().getChildB());
            } else {
                PerspectiveDockable dockable = child.asLeaf().getDockable();
                if (dockable != null) {
                    this.add(dockable);
                }
            }
        }
    }

    private void add(PerspectiveDockable dockable) {
        PerspectiveStation station;
        CDockablePerspective cdockable;
        if (dockable instanceof CommonElementPerspective && (cdockable = ((CommonElementPerspective)((Object)dockable)).getElement().asDockable()).getWorkingArea() == null) {
            cdockable.setWorkingArea(this);
        }
        if ((station = dockable.asStation()) != null) {
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.add(station.getDockable(i));
            }
        }
    }
}

