/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSetting
extends Setting {
    private ModeSettings<Location, ?> modes;
    private Map<String, List<String>> multiFactoryDockables = new HashMap<String, List<String>>();

    public void setModes(ModeSettings<Location, ?> modes) {
        this.modes = modes;
    }

    public ModeSettings<Location, ?> getModes() {
        return this.modes;
    }

    public void putMultipleFactoryDockables(String factoryId, List<String> dockables) {
        if (dockables == null) {
            throw new IllegalArgumentException("dockables must not be null");
        }
        this.multiFactoryDockables.put(factoryId, dockables);
    }

    public List<String> getMultipleFactoryDockables(String factoryId) {
        return this.multiFactoryDockables.get(factoryId);
    }

    @Override
    public void write(DockSituation situation, PropertyTransformer transformer, boolean entry, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_8);
        super.write(situation, transformer, entry, out);
        this.modes.write(out);
        out.writeInt(this.multiFactoryDockables.size());
        for (Map.Entry<String, List<String>> factory : this.multiFactoryDockables.entrySet()) {
            out.writeUTF(factory.getKey());
            List<String> list = factory.getValue();
            out.writeInt(list.size());
            for (String dockable : list) {
                out.writeUTF(dockable);
            }
        }
    }

    @Override
    public void writeXML(DockSituation situation, PropertyTransformer transformer, boolean entry, XElement element) {
        super.writeXML(situation, transformer, entry, element.addElement("base"));
        this.modes.writeXML(element.addElement("modes"));
        if (!this.multiFactoryDockables.isEmpty()) {
            XElement xmultiFactories = element.addElement("multi-factories");
            for (Map.Entry<String, List<String>> factory : this.multiFactoryDockables.entrySet()) {
                XElement xfactory = xmultiFactories.addElement("factory");
                xfactory.addString("id", factory.getKey());
                for (String dockable : factory.getValue()) {
                    xfactory.addElement("dockable").addString("id", dockable);
                }
            }
        }
    }

    @Override
    public void read(DockSituation situation, PropertyTransformer transformer, boolean entry, DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        boolean version7 = version.compareTo(Version.VERSION_1_0_7) >= 0;
        super.read(situation, transformer, entry, in);
        this.modes.read(in);
        if (version7) {
            int n = in.readInt();
            for (int i = 0; i < n; ++i) {
                String id = in.readUTF();
                ArrayList<String> dockables = new ArrayList<String>();
                int m = in.readInt();
                for (int j = 0; j < m; ++j) {
                    dockables.add(in.readUTF());
                }
                this.putMultipleFactoryDockables(id, dockables);
            }
        }
    }

    @Override
    public void readXML(DockSituation situation, PropertyTransformer transformer, boolean entry, XElement element) {
        super.readXML(situation, transformer, entry, element.getElement("base"));
        this.modes.readXML(element.getElement("modes"));
        XElement xmultiFactories = element.getElement("multi-factories");
        if (xmultiFactories != null) {
            for (XElement xfactory : xmultiFactories.getElements("factory")) {
                ArrayList<String> dockables = new ArrayList<String>();
                for (XElement xdockable : xfactory.getElements("dockable")) {
                    String id = xdockable.getString("id");
                    if (id == null) continue;
                    dockables.add(id);
                }
                String id = xfactory.getString("id");
                if (id == null) continue;
                this.putMultipleFactoryDockables(id, dockables);
            }
        }
    }
}

