/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.station.flap.FlapDockPropertyFactory;
import bibliothek.gui.dock.station.screen.ScreenDockPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockFullScreenPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockPathPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockPropertyFactory;
import bibliothek.gui.dock.station.stack.StackDockPropertyFactory;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PropertyTransformer {
    private Map<String, DockablePropertyFactory> factories = new HashMap<String, DockablePropertyFactory>();

    public PropertyTransformer() {
        this(SplitDockPropertyFactory.FACTORY, SplitDockPathPropertyFactory.FACTORY, SplitDockPlaceholderPropertyFactory.FACTORY, SplitDockFullScreenPropertyFactory.FACTORY, StackDockPropertyFactory.FACTORY, FlapDockPropertyFactory.FACTORY, ScreenDockPropertyFactory.FACTORY);
    }

    public PropertyTransformer(DockablePropertyFactory ... factories) {
        for (DockablePropertyFactory factory : factories) {
            this.factories.put(factory.getID(), factory);
        }
    }

    public void addFactory(DockablePropertyFactory factory) {
        this.factories.put(factory.getID(), factory);
    }

    public void write(DockableProperty property, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_4);
        int count = 0;
        for (DockableProperty successor = property; successor != null; successor = successor.getSuccessor()) {
            ++count;
        }
        out.writeInt(count);
        while (property != null) {
            out.writeUTF(property.getFactoryID());
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream datas = new DataOutputStream(bytes);
            property.store(datas);
            datas.close();
            byte[] written = bytes.toByteArray();
            out.writeInt(written.length);
            out.write(written);
            property = property.getSuccessor();
        }
    }

    public DockableProperty read(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        int count = in.readInt();
        DockableProperty property = null;
        DockableProperty base = null;
        for (int i = 0; i < count; ++i) {
            int read;
            String id = in.readUTF();
            DockablePropertyFactory factory = this.factories.get(id);
            if (factory == null) {
                throw new IOException("Unknown factory-id: " + id);
            }
            DockableProperty temp = factory.createProperty();
            int length = in.readInt();
            byte[] data = new byte[length];
            for (int index = 0; index < length; index += read) {
                read = in.read(data, index, length - index);
                if (read >= 0) continue;
                throw new EOFException();
            }
            DataInputStream datas = new DataInputStream(new ByteArrayInputStream(data));
            temp.load(datas);
            datas.close();
            if (base == null) {
                base = temp;
                property = temp;
                continue;
            }
            property.setSuccessor(temp);
            property = temp;
        }
        return base;
    }

    public void writeXML(DockableProperty property, XElement element) {
        while (property != null) {
            XElement xnode = element.addElement("property");
            xnode.addString("factory", property.getFactoryID());
            property.store(xnode);
            property = property.getSuccessor();
        }
    }

    public DockableProperty readXML(XElement element) {
        DockableProperty base = null;
        DockableProperty property = null;
        for (XElement xnode : element.getElements("property")) {
            DockablePropertyFactory factory = this.factories.get(xnode.getString("factory"));
            if (factory == null) {
                throw new IllegalArgumentException("Missing factory: " + xnode.getString("factory"));
            }
            DockableProperty next = factory.createProperty();
            next.load(xnode);
            if (property == null) {
                property = next;
                base = next;
                continue;
            }
            property.setSuccessor(next);
            property = next;
        }
        return base;
    }
}

