/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.OwnedRectEclipseBorder;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BaseTabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.DefaultInvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.LinePainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPanePainter;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class RectGradientPainter
extends BaseTabComponent {
    public static final TabPainter FACTORY = new TabPainter(){

        public TabComponent createTabComponent(EclipseTabPane pane, Dockable dockable) {
            return new RectGradientPainter(pane, dockable);
        }

        public TabPanePainter createDecorationPainter(EclipseTabPane pane) {
            return new LinePainter(pane);
        }

        public InvisibleTab createInvisibleTab(InvisibleTabPane pane, Dockable dockable) {
            return new DefaultInvisibleTab(pane, dockable);
        }

        public Border getFullBorder(BorderedComponent owner, DockController controller, Dockable dockable) {
            return new OwnedRectEclipseBorder(owner, controller, true);
        }
    };
    private MatteBorder contentBorder = new MatteBorder(2, 2, 2, 2, Color.BLACK);

    public RectGradientPainter(EclipseTabPane pane, Dockable dockable) {
        super(pane, dockable);
        this.setLayout(null);
        this.setOpaque(false);
        this.update();
        this.updateBorder();
    }

    public Insets getOverlap(TabComponent other) {
        return new Insets(0, 0, 0, 0);
    }

    public void updateFocus() {
        this.update();
        this.updateBorder();
        this.updateFont();
    }

    protected void updateOrientation() {
        this.update();
    }

    protected void updateSelected() {
        this.update();
        this.updateBorder();
        this.updateFont();
    }

    protected void updateColors() {
        this.update();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void update() {
        Insets labelInsets = null;
        Insets buttonInsets = null;
        switch (this.getOrientation()) {
            case TOP_OF_DOCKABLE: 
            case BOTTOM_OF_DOCKABLE: {
                labelInsets = new Insets(3, 5, 3, 2);
                buttonInsets = new Insets(1, 2, 1, 5);
                break;
            }
            case LEFT_OF_DOCKABLE: 
            case RIGHT_OF_DOCKABLE: {
                labelInsets = new Insets(5, 3, 2, 3);
                buttonInsets = new Insets(2, 1, 5, 1);
            }
        }
        this.getLabel().setForeground(this.getTextColor());
        this.setLabelInsets(labelInsets);
        this.setButtonInsets(buttonInsets);
        this.revalidate();
        this.repaint();
    }

    private Color getTextColor() {
        boolean focusTemporarilyLost = this.isFocusTemporarilyLost();
        if (this.isFocused() && !focusTemporarilyLost) {
            return (Color)this.colorStackTabTextSelectedFocused.value();
        }
        if (this.isFocused() && focusTemporarilyLost) {
            return (Color)this.colorStackTabTextSelectedFocusLost.value();
        }
        if (this.isSelected()) {
            return (Color)this.colorStackTabTextSelected.value();
        }
        return (Color)this.colorStackTabText.value();
    }

    public void updateBorder() {
        int index;
        EclipseTabPane pane;
        Window window = SwingUtilities.getWindowAncestor(this.getComponent());
        boolean focusTemporarilyLost = false;
        if (window != null) {
            boolean bl = focusTemporarilyLost = !window.isActive();
        }
        Color color2 = this.isSelected() ? (this.isFocused() ? (focusTemporarilyLost ? (Color)this.colorStackTabBorderSelectedFocusLost.value() : (Color)this.colorStackTabBorderSelectedFocused.value()) : (Color)this.colorStackTabBorderSelected.value()) : (Color)this.colorStackTabBorder.value();
        if (!color2.equals(this.contentBorder.getMatteColor())) {
            this.contentBorder = new MatteBorder(2, 2, 2, 2, color2);
        }
        if ((pane = this.getPane()) != null && (index = this.getDockableIndex()) >= 0) {
            pane.setContentBorderAt(index, this.contentBorder);
        }
    }

    public void paintBackground(Graphics g) {
        Color color2;
        Color color1;
        int height = this.getHeight();
        int width = this.getWidth();
        Graphics2D g2d = (Graphics2D)g;
        Color lineColor = (Color)this.colorStackBorder.value();
        boolean focusTemporarilyLost = this.isFocusTemporarilyLost();
        boolean isSelected = this.isSelected();
        TabPlacement orientation = this.getOrientation();
        if (this.isFocused() && !focusTemporarilyLost) {
            color1 = (Color)this.colorStackTabTopSelectedFocused.value();
            color2 = (Color)this.colorStackTabBottomSelectedFocused.value();
        } else if (this.isFocused() && focusTemporarilyLost) {
            color1 = (Color)this.colorStackTabTopSelectedFocusLost.value();
            color2 = (Color)this.colorStackTabBottomSelectedFocusLost.value();
        } else if (isSelected) {
            color1 = (Color)this.colorStackTabTopSelected.value();
            color2 = (Color)this.colorStackTabBottomSelected.value();
        } else {
            color1 = (Color)this.colorStackTabTop.value();
            color2 = (Color)this.colorStackTabBottom.value();
        }
        if (orientation == TabPlacement.BOTTOM_OF_DOCKABLE || orientation == TabPlacement.RIGHT_OF_DOCKABLE) {
            Color temp = color1;
            color1 = color2;
            color2 = temp;
        }
        GradientPaint gradient = null;
        if (!color1.equals(color2)) {
            gradient = orientation.isHorizontal() ? new GradientPaint(0.0f, 0.0f, color1, 0.0f, height, color2) : new GradientPaint(0.0f, 0.0f, color1, width, 0.0f, color2);
        }
        int tabIndex = this.getTabIndex();
        g2d.setColor(lineColor);
        Paint old = g2d.getPaint();
        if (gradient != null) {
            g2d.setPaint(gradient);
        } else {
            g2d.setPaint(color1);
        }
        if (isSelected) {
            this.paintSelected(g2d, tabIndex, old);
        } else {
            switch (orientation) {
                case TOP_OF_DOCKABLE: {
                    g.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
                    break;
                }
                case BOTTOM_OF_DOCKABLE: {
                    g.fillRect(0, 1, this.getWidth(), this.getHeight() - 1);
                    break;
                }
                case LEFT_OF_DOCKABLE: {
                    g.fillRect(0, 0, this.getWidth() - 1, this.getHeight());
                    break;
                }
                case RIGHT_OF_DOCKABLE: {
                    g.fillRect(1, 0, this.getWidth() - 1, this.getHeight());
                }
            }
            g2d.setPaint(old);
        }
    }

    public void paintForeground(Graphics g) {
        if (!this.isSelected() && !this.isNextTabSelected()) {
            Color lineColor = (Color)this.colorStackBorder.value();
            TabPlacement orientation = this.getOrientation();
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(lineColor);
            switch (orientation) {
                case TOP_OF_DOCKABLE: 
                case BOTTOM_OF_DOCKABLE: {
                    g.drawLine(width - 1, 0, width - 1, height);
                    break;
                }
            }
        }
    }

    private void paintSelected(Graphics2D g2d, int tabIndex, Paint normalBackground) {
        TabPlacement orientation = this.getOrientation();
        int width = this.getWidth();
        int height = this.getHeight();
        switch (orientation) {
            case TOP_OF_DOCKABLE: {
                g2d.fillRect(1, 0, width - 2, height);
                g2d.drawLine(0, 1, 0, height);
                g2d.setPaint(normalBackground);
                if (tabIndex != 0) {
                    g2d.drawLine(1, 0, 1, 0);
                    g2d.drawLine(0, 1, 0, height);
                }
                g2d.drawLine(width - 2, 0, width - 2, 0);
                g2d.drawLine(width - 1, 1, width - 1, height);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                g2d.fillRect(1, 0, width - 2, height);
                g2d.drawLine(0, height - 2, 0, 0);
                g2d.setPaint(normalBackground);
                if (tabIndex != 0) {
                    g2d.drawLine(1, height - 1, 1, height - 1);
                    g2d.drawLine(0, height - 2, 0, 0);
                }
                g2d.drawLine(width - 2, height - 1, width - 2, height - 1);
                g2d.drawLine(width - 1, height - 2, width - 1, 0);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                g2d.fillRect(0, 1, width, height - 2);
                g2d.drawLine(1, 0, width, 0);
                g2d.setPaint(normalBackground);
                if (tabIndex != 0) {
                    g2d.drawLine(0, 1, 0, 1);
                    g2d.drawLine(1, 0, width, 0);
                }
                g2d.drawLine(0, height - 2, 0, height - 2);
                g2d.drawLine(1, height - 1, width, height - 1);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                g2d.fillRect(0, 1, width, height - 2);
                g2d.drawLine(0, 0, width - 1, 0);
                g2d.setPaint(normalBackground);
                if (tabIndex != 0) {
                    g2d.drawLine(width - 1, 1, width - 1, 1);
                    g2d.drawLine(0, 0, width - 2, 0);
                }
                g2d.drawLine(width - 1, height - 2, width - 1, height - 2);
                g2d.drawLine(0, height - 1, width - 2, height - 1);
            }
        }
    }
}

