% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{has_nir_dip}
\alias{has_nir_dip}
\title{Has a dip in the NIR region?}
\usage{
has_nir_dip(x, smooth = TRUE, ...)
}
\arguments{
\item{x}{spectra object}

\item{smooth}{boolean. Smooth spectra internally? Defaults to TRUE}

\item{...}{additional parameters passed to `spectrolab::smooth` (method spline)}
}
\value{
boolean vector
}
\description{
\code{has_nir_dip} tests if spectra have a NIR dip
}
\details{
Because the NIR dip is detected using features on the second derivative, high
frequency noise in the spectra is likely to spoil the method and give false
positives. Ideally, spectra should have been been smoothed (`spectrolab::smooth`)
before trying to detect an NIR dip. If param `smooth` is set to TRUE (default),
`has_nir_dip` does some basic smoothing internally.
}
\examples{
library(spectrolab)
spec  = as.spectra(spec_matrix_example, name_idx = 1)

# Find spec with NIR dip
# Set parallel = TRUE if many samples need testing.
dip = has_nir_dip(spec, parallel = FALSE)

# remove NIR dip
spec = spec[ ! dip, ]
}
\author{
Jose Eduardo Meireles
}
