% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddPlottingStuff.R
\name{AddPlottingStuff}
\alias{AddPlottingStuff}
\title{Add plotting variables}
\usage{
AddPlottingStuff(Y.peaks, X.ppm = NULL, groupLabels = NULL)
}
\arguments{
\item{Y.peaks}{data frame obtained from either of the 'getWaveletPeaks', 'PeakAligner' or 'PeakFilling' function.}

\item{X.ppm}{The vector with the ppm values (numeric vector).}

\item{groupLabels}{The groupLabels (numeric or factor).}
}
\value{
Returns a data frame with added plotting variables (groupPPM for aligned features and labels for plotting).
}
\description{
This functions adds a few variables which make plotting features easier (and more informative). Since for example every peaks keeps it original ppm value, if you want to plot the groups this function adds the group ppm value. Also sample labels can be added.
}
\examples{
\dontrun{
# This function works on a data frame resulting from the 'getWaveletPeaks' function 
# DetectedPeaks <- getWaveletPeaks(X.ppm= PPM.vector, Y=Y.spec,  baselineThresh = 10,nCPU  = 4)
Aligned.peaks = PeakAligner = function (Y.peaks = DetectedPeaks)
}

}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}

