% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.spdur.R
\name{sepplot}
\alias{sepplot}
\title{Generate a Separation Plot}
\usage{
sepplot(
  x,
  pred_type = "conditional hazard",
  obs = NULL,
  endSpellOnly = FALSE,
  lwd1 = 5,
  lwd2 = 2,
  shuffle = TRUE,
  heading = "",
  show.expected = TRUE,
  newplot = FALSE,
  type = "line",
  ...
)
}
\arguments{
\item{x}{An object of class "\code{spdur}".}

\item{pred_type}{Which statistic to plot, i.e. "conditional hazard" or 
"conditional risk".}

\item{obs}{Variable that captures observed outcomes. If \code{NULL} (default), 
it is chosen based on \code{pred_type}: "fail" for (conditional) hazard, and 
"atrisk" for (conditional) risk.}

\item{endSpellOnly}{Should only the last observation in each spell be kept? 
\code{FALSE} by default.}

\item{lwd1}{See \code{\link[separationplot]{separationplot}}.}

\item{lwd2}{See \code{\link[separationplot]{separationplot}}.}

\item{shuffle}{See \code{\link[separationplot]{separationplot}}.}

\item{heading}{See \code{\link[separationplot]{separationplot}}.}

\item{show.expected}{See \code{\link[separationplot]{separationplot}}.}

\item{newplot}{See \code{\link[separationplot]{separationplot}}}

\item{type}{See \code{\link[separationplot]{separationplot}}.}

\item{\dots}{Optional parameters passed to \code{\link[separationplot]{separationplot}}, 
e.g. type of statistic to calculate.}
}
\description{
A \code{\link[separationplot]{separationplot}} wrapper for class 
``\code{spdur}''.
}
\details{
Creates a separation plot of fitted values from 
split-duration model results using \code{\link{predict.spdur}}.
}
\examples{
# get model estimates
library(separationplot)
data(model.coups)

# plot
p <- plot(model.coups)
p

}
\seealso{
\code{\link[separationplot]{separationplot}}, \code{\link{predict.spdur}}
}
