/*
 * Decompiled with CFR 0.152.
 */
package partition;

import partition.Cell;
import partition.Cluster;
import partition.CompactSpatialPartition;
import partition.Location;

public class CompactSpatialPartitionTransfer
extends CompactSpatialPartition {
    public CompactSpatialPartitionTransfer(Location[] cellCenters, Location[] clusterCenters, boolean[] priorPoint) {
        int numberOfCells = cellCenters.length;
        int numberOfClusters = clusterCenters.length;
        this._clusters = new Cluster[numberOfClusters];
        for (int k = 0; k < numberOfClusters; ++k) {
            Cluster cluster;
            this._clusters[k] = cluster = new Cluster(k, clusterCenters[k], priorPoint[k]);
        }
        this._cells = new Cell[numberOfCells];
        for (int i = 0; i < numberOfCells; ++i) {
            Cell cell = new Cell(i, cellCenters[i]);
            Cluster cluster = cell.findNearest(this._clusters);
            cluster.add(cell);
            this._cells[i] = cell;
        }
    }

    @Override
    final int runCycle() {
        for (Cluster cluster : this._clusters) {
            cluster.deactivate();
        }
        int numberOfTransfers = 0;
        block1: for (Cell cell : this._cells) {
            Cluster cluster1 = cell.getCluster();
            boolean isActive1 = cluster1.isActive();
            Location cCell = cell.getCenter();
            Location cCluster1 = cluster1.getCenter();
            double distance1 = cCell.getSquaredDistanceTo(cCluster1);
            for (Cluster cluster2 : this._clusters) {
                boolean transfer;
                boolean isActive2;
                if (cluster1 == cluster2 || !(isActive1 | (isActive2 = cluster2.isActive()))) continue;
                Location cCluster2 = cluster2.getCenter();
                double distance2 = cCell.getSquaredDistanceTo(cCluster2);
                boolean bl = transfer = distance2 < distance1;
                if (!transfer) continue;
                ++numberOfTransfers;
                cluster1.remove(cell);
                cluster2.add(cell);
                cluster1.activate();
                cluster2.activate();
                continue block1;
            }
        }
        return numberOfTransfers;
    }
}

