##
## rotmean.R
##
## rotational average of pixel values
##
##  $Revision: 1.9 $ $Date: 2015/06/18 02:45:42 $

rotmean <- function(X, ..., origin, padzero=TRUE, Xname, result=c("fv", "im")) {
  if(missing(Xname))
    Xname <- sensiblevarname(short.deparse(substitute(X)), "X")
  trap.extra.arguments(..., .Context="rotmean")
  stopifnot(is.im(X))
  if(!missing(origin))
    X <- shift(X, origin=origin)
  result <- match.arg(result)
  rmax <- with(vertices(Frame(X)), sqrt(max(x^2+y^2)))
  if(padzero) 
    X <- padimage(na.handle.im(X, 0), 0, W=square(c(-1,1)*rmax))
  values <- X[drop=TRUE]
  radii <- with(as.data.frame(rasterxy.im(X, drop=TRUE)), sqrt(x^2+y^2))
  ra <- pmin(range(radii), rmax)
  eps <- sqrt(X$xstep^2 + X$ystep^2)
  a <- unnormdensity(radii,                 from=ra[1], to=ra[2], bw=eps)
  b <- unnormdensity(radii, weights=values, from=ra[1], to=ra[2], bw=eps)
  df <- data.frame(r=a$x, f=b$y/a$y)
  FUN <- fv(df,
            argu="r",
            ylab=substitute(bar(X)(r), list(X=as.name(Xname))),
            valu="f",
            fmla=(. ~ r),
            alim=ra,
            labl=c("r", "%s(r)"),
            desc=c("distance argument r",
                "rotational average"),
            unitname=unitname(X),
            fname=paste0("bar", paren(Xname)))
  attr(FUN, "dotnames") <- "f"
  if(result == "fv") return(FUN)
  ## compute image
  FUN <- as.function(FUN)
  XX <- as.im(X, na.replace=1)
  IM <- as.im(function(x,y,FUN){ FUN(sqrt(x^2+y^2)) }, XX, FUN=FUN)
  return(IM)
}
