\name{anova.mppm}
\alias{anova.mppm}
\title{ANOVA for Fitted Multiple Point Process Models}
\description{
  Performs analysis of deviance for two or more fitted multiple
  point process models.
}
\usage{
  \method{anova}{mppm}(object, \dots, test=NULL, override=FALSE)
}
\arguments{
  \item{object}{A fitted multiple point process model
    (object of class \code{"mppm"}).
    }
    \item{\dots}{
      One or more fitted multiple point process models.
    }
    \item{test}{
      Type of hypothesis test to perform. 
      A character string, partially matching one of
      \code{"Chisq"}, \code{"F"} or \code{"Cp"},
      or \code{NULL}. 
    }
    \item{override}{
      Logical flag indicating whether to proceed even when there is
      no statistical theory to support the calculation.
    }
}
\value{
  An object of class \code{"anova"}, or \code{NULL}.
}
\details{
  This is a method for \code{\link{anova}} for comparing several
  fitted multiple point process models (objects of class \code{"mppm"},
  usually generated by the model-fitting function \code{\link{mppm}}).

  If the fitted models are all Poisson point processes,
  then this function performs an Analysis of Deviance of
  the fitted models. The output shows the deviance differences
  (i.e. 2 times log likelihood ratio),
  the difference in degrees of freedom, and (if \code{test="Chi"})
  the two-sided p-values for the chi-squared tests. Their interpretation
  is very similar to that in \code{\link{anova.glm}}.

  If some of the fitted models are \emph{not} Poisson point processes,
  then there is no statistical theory available to support
  a similar analysis. The function issues a warning,
  and (by default) returns a \code{NULL} value.

  However if \code{override=TRUE},
  then a kind of analysis of deviance table will be printed.
  The `deviance' differences in this table are equal to 2 times the differences
  in the maximised values of the log pseudolikelihood (see
  \code{\link{mppm}}). At the time of writing, there is no statistical
  theory to support inferential interpretation of log pseudolikelihood
  ratios. The \code{override} option is provided for research purposes
  only!

  The argument \code{test} determines which hypothesis test, if any, will
  be performed to compare the models. The argument \code{test}
  should be a character string, partially matching one of
  \code{"Chisq"}, \code{"F"} or \code{"Cp"},
  or \code{NULL}. The first option \code{"Chisq"} gives
  the likelihood ratio test based on the asymptotic chi-squared
  distribution of the deviance difference.
  The meaning of the other options is explained in
  \code{\link{anova.glm}}.
  For random effects models, only \code{"Chisq"} is
  available, and again gives the likelihood ratio test.
}
\seealso{
  \code{\link{mppm}}
}
\examples{
 H <- hyperframe(X=waterstriders)
 mod0 <- mppm(X~1, H, Poisson())
 modx <- mppm(X~x, H, Poisson())
 anova.mppm(mod0, modx, test="Chi")
}
\references{
  Baddeley, A., Rubak, E. and Turner, R. (2015)
  \emph{Spatial Point Patterns: Methodology and Applications with R}.
  London: Chapman and Hall/CRC Press. 
}
\author{
  Adrian Baddeley, Ida-Maria Sintorn and Leanne Bischoff.
  Implemented by 
  Adrian Baddeley
  \email{Adrian.Baddeley@uwa.edu.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  Rolf Turner
  \email{r.turner@auckland.ac.nz}
  and Ege Rubak
  \email{rubak@math.aau.dk}
}
\keyword{spatial}
\keyword{models}
\keyword{methods}
 
 
