#
#  colourtools.R
#
#   $Revision: 1.1 $   $Date: 2010/06/14 12:19:15 $
#


rgb2hex <- function(v) {
  stopifnot(is.numeric(v))
  if(is.matrix(v)) {
    stopifnot(ncol(v) == 3)
  } else {
    if(length(v) != 3)
      stop("v should be a vector of length 3 or a matrix with 3 columns")
    v <- matrix(v, ncol=3)
  } 
  out <- rgb(v[,1], v[,2], v[,3], maxColorValue=255)
  return(out)
}

col2hex <- function(x) { apply(col2rgb(x), 2, rgb2hex) }

paletteindex <- function(x) {
  x <- col2hex(x)
  p <- col2hex(palette())
  m <- match(x, p)
  return(m)
}

samecolour <- function(x, y) { col2hex(x) == col2hex(y) }

