% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_indic.R
\name{create_indicator}
\alias{create_indicator}
\alias{custom_indicator}
\alias{compute_indicator}
\title{Custom Spatial Early-Warning signals}
\usage{
create_indicator(fun, taskname = as.character(substitute(fun)))

compute_indicator(mat, fun, taskname = as.character(substitute(fun)), ...)
}
\arguments{
\item{fun}{A function that takes a matrix as input and returns 
a vector of numerical values. If the function returns a named vector, 
then the names will be used in plots and summaries. The function may also
accept extra arguments.}

\item{taskname}{The task name. A character string used used for plots and
textual summaries that describes the indicator (or set of indicators) 
being computed. If a task name cannot be derived from \code{fun}, then 
default name is used.}

\item{mat}{A matrix or a list of matrices.}

\item{...}{Additional arguments being passed to the function \code{fun}}
}
\value{
\code{create_indicator} returns a function that can be used in the same way 
  than the other \code{*_sews} functions (e.g. \code{generic_sews}). This 
  function as well as \code{compute_indicator} will return
  \code{\link[=simple_sews]{simple_sews_*}} objects.
}
\description{
Computation, significance assessment and display of trends 
  of a custom, user-defined indicator.
}
\details{
\code{spatialwarnings} provides "workflow functions", named \code{*_sews}, 
  that assist the user in computing, displaying and assessing the 
  significance of indicator values. The functions \code{create_indicator} and 
  \code{compute_indicator} provides such workflow for any arbitrary function. 
  
\code{create_indicator} takes a function `fun` and returns another function 
  that can be used as an indicator similar to the \code{*_sews} functions. The 
  results of this function can be assessed for significance using 
  \code{indictest} and trends can be displayed using 
  \code{plot}, \code{summary}, etc. (see Examples). \code{compute_indicator} 
  does the same but without needing an intermediate indicator function.
}
\examples{

# Use the maximum patch size as indicator of degradation
maxpatchsize <- function(mat) { 
  max(patchsizes(mat))
}

# Create the indicator function
maxpatch_sews <- create_indicator(maxpatchsize)

# Then work with this function as if it were a function from the *_sews 
# family. 
mp_indic <- maxpatch_sews(forestgap)
summary(mp_indic)

\dontrun{ 
# Assess significance and display trends
mp_test <- indictest(mp_indic, nulln = 49)
plot(mp_test)
}



# Try spatial coefficient of variation as a spatial EWS. This function can 
# have arguments. 
spatial_cv <- function(mat, subsize) { 
  matc <- coarse_grain(mat, subsize)
  return( sd(matc) / mean(matc) )
}

# Create indicator function
cv_sews <- create_indicator(spatial_cv)

# Compute and display trends
cv_indic <- cv_sews(serengeti, subsize = 3)
plot(cv_indic, along = serengeti.rain)

# We can do the same work in one run using compute_indicator
cv_indic2 <- compute_indicator(serengeti, spatial_cv, subsize = 3)
plot(cv_indic2, along = serengeti.rain)

\dontrun{ 
indictest(cv_indic, nulln = 99)
}
}
\seealso{
\code{\link{simple_sews}}
}
