% Generated by roxygen2 (4.0.2): do not edit by hand
\name{KNMIdata}
\alias{KNMIdata}
\title{Wind speeds in the Netherlands.}
\format{KNMIdata$data is a matrix with 672 rows and 22 columns, KNMI$loc is a matrix with 22 rows
and 2 columns.}
\source{
\url{http://www.knmi.nl/climatology/daily_data/selection.cgi}
}
\description{
Daily maximal speeds of wind gusts, measured in 0.1 m/s. The data are observed at
22 inland weather stations in the Netherlands. Only the summer months are presented
here (June, July, August). Also included are the Euclidian coordinates of the 22
weather stations, where a distance of 1 corresponds to 100 kilometers. For more
information on this dataset, see Einmahl et al. (2014).
}
\examples{
data(KNMIdata)
locations <- KNMIdata$loc
pairIndices <- selectPairIndices(locations, maxDistance = 0.5)
Mestimator(KNMIdata$data, locations, pairIndices, k = 60, model="BR",
iterate=FALSE, covMat = FALSE)$theta
}
\references{
Einmahl, J.H.J., Kiriliouk, A., Krajina, A. and Segers, J. (2014), "An M-estimator of spatial tail dependence". See \url{http://arxiv.org/abs/1403.1975}.
}

