% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_spatial_fold.R
\name{make_spatial_fold}
\alias{make_spatial_fold}
\title{Makes one training and one testing spatial folds}
\usage{
make_spatial_fold(
  data = NULL,
  dependent.variable.name = NULL,
  xy.i = NULL,
  xy = NULL,
  distance.step.x = NULL,
  distance.step.y = NULL,
  training.fraction = 0.8
)
}
\arguments{
\item{data}{Data frame with a response variable and a set of predictors. Default: \code{NULL}}

\item{dependent.variable.name}{Character string with the name of the response variable. Must be in the column names of \code{data}. Default: \code{NULL}}

\item{xy.i}{One row data frame with at least three columns: "x" (longitude), "y" (latitude), and "id" (integer, id of the record). Can be a row of \code{xy}. Default: \code{NULL}.}

\item{xy}{A data frame with at least three columns: "x" (longitude), "y" (latitude), and "id" (integer, index of the record). Default: \code{NULL}.}

\item{distance.step.x}{Numeric, distance step used during the growth in the x axis of the buffers defining the training folds. Default: \code{NULL} (1/1000th the range of the x coordinates).}

\item{distance.step.y}{Numeric, distance step used during the growth in the y axis of the buffers defining the training folds. Default: \code{NULL} (1/1000th the range of the y coordinates).}

\item{training.fraction}{Numeric, fraction of the data to be included in the training fold, Default: \code{0.8}.}
}
\value{
A list with two slots named \code{training} and \code{testing} with the former having the indices of the training records selected from \code{xy}, and the latter having the indices of the testing records.
}
\description{
Used internally by \code{\link[=make_spatial_folds]{make_spatial_folds()}} and \code{\link[=rf_evaluate]{rf_evaluate()}}. Uses the coordinates of a point \code{xy.i} to generate two spatially independent data folds from the data frame \code{xy}. It does so by growing a rectangular buffer from \code{xy.i} until a number of records defined by \code{training.fraction} is inside the buffer. The indices of these records are then stored as "training" in the output list. The indices of the remaining records outside of the buffer are stored as "testing". These training and testing records can be then used to evaluate a model on independent data via cross-validation.
}
\examples{
if(interactive()){

 #loading example data
 data(plant_richness_df)

 #getting case coordinates
 xy <- plant_richness_df[, 1:3]
 colnames(xy) <- c("id", "x", "y")

 #building a spatial fold centered in the first pair of coordinates
 out <- make_spatial_fold(
   xy.i = xy[1, ],
   xy = xy,
   training.fraction = 0.6
 )

 #indices of the training and testing folds
 out$training
 out$testing

 #plotting the data
 plot(xy[ c("x", "y")], type = "n", xlab = "", ylab = "")
 #plots training points
 points(xy[out$training, c("x", "y")], col = "red4", pch = 15)
 #plots testing points
 points(xy[out$testing, c("x", "y")], col = "blue4", pch = 15)
 #plots xy.i
 points(xy[1, c("x", "y")], col = "black", pch = 15, cex = 2)

}
}
\seealso{
\code{\link[=make_spatial_folds]{make_spatial_folds()}}, \code{\link[=rf_evaluate]{rf_evaluate()}}
}
