% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/nni.R
\name{nni}
\alias{nni}
\title{Average Nearest Neighbor Index (NNI)}
\usage{
nni(x, win = "hull")
}
\arguments{
\item{x}{An sp point object}

\item{win}{Type of window 'hull' or 'extent'}
}
\value{
NNI value
}
\description{
Calculates the NNI as a measure of clustering or dispersal
}
\note{
The nearest neighbor index is expressed as the ratio of the observed distance divided by the expected distance. The expected distance is the average distance between neighbors in a hypothetical random distribution. If the index is less than 1, the pattern exhibits clustering; if the index is greater than 1, the trend is toward dispersion or competition.
The Nearest Neighbor Index is calculated as:
  Nearest Neighbor Distance (observed) D(nn) = sum(min(Dij)/N)
  Mean Random Distance (expected) D(e) = 0.5 SQRT(A/N)
  Nearest Neighbor Index NNI = D(nn)/D(e)
      Where; D=neighbor distance, A=Area

Depends: sp, spatstat
}
\examples{
require(sp)
data(meuse)
  coordinates(meuse) <- ~x+y
    nni(meuse)
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
\references{
Clark, P.J., and F.C. Evans (1954) Distance to nearest neighbor as a measure of spatial relationships in populations. Ecology 35:445-453

Cressie, N (1991) Statistics for spatial data. Wiley & Sons, New York.
}

