% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_hof.R
\name{hof_filter}
\alias{hof_filter}
\title{Filter Array Column}
\usage{
hof_filter(x, func, expr = NULL, dest_col = NULL, ...)
}
\arguments{
\item{x}{The Spark data frame to filter}

\item{func}{The filtering function}

\item{expr}{The array being filtered, could be any SQL expression evaluating to an array
(default: the last column of the Spark data frame)}

\item{dest_col}{Column to store the filtered result (default: expr)}

\item{...}{Additional params to dplyr::mutate}
}
\description{
Apply an element-wise filtering function to an array column
(this is essentially a dplyr wrapper for the
\code{filter(array<T>, function<T, Boolean>): array<T>} built-in Spark SQL functions)
}
\examples{
\dontrun{

library(sparklyr)
sc <- spark_connect(master = "local")
# only keep odd elements in each array in `array_column`
copy_to(sc, tibble::tibble(array_column = list(1:5, 21:25))) \%>\%
  hof_filter(~ .x \%\% 2 == 1)
}

}
