/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor;

import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.processor.BatchedColumnReaderProcessor;
import com.univocity.parsers.common.processor.ColumnSplitter;
import com.univocity.parsers.common.processor.RowProcessor;
import java.util.List;
import java.util.Map;

public abstract class BatchedColumnProcessor
implements RowProcessor,
BatchedColumnReaderProcessor<String> {
    private final ColumnSplitter<String> splitter;
    private final int rowsPerBatch;
    private int batchCount;
    private int batchesProcessed;

    public BatchedColumnProcessor(int rowsPerBatch) {
        this.splitter = new ColumnSplitter(rowsPerBatch);
        this.rowsPerBatch = rowsPerBatch;
    }

    @Override
    public void processStarted(ParsingContext context) {
        this.splitter.reset();
        this.batchCount = 0;
        this.batchesProcessed = 0;
    }

    @Override
    public void rowProcessed(String[] row, ParsingContext context) {
        this.splitter.addValuesToColumns((String[])row, context);
        ++this.batchCount;
        if (this.batchCount >= this.rowsPerBatch) {
            this.batchProcessed(this.batchCount);
            this.batchCount = 0;
            this.splitter.clearValues();
            ++this.batchesProcessed;
        }
    }

    @Override
    public void processEnded(ParsingContext context) {
        if (this.batchCount > 0) {
            this.batchProcessed(this.batchCount);
        }
    }

    @Override
    public final String[] getHeaders() {
        return this.splitter.getHeaders();
    }

    @Override
    public final List<List<String>> getColumnValuesAsList() {
        return this.splitter.getColumnValues();
    }

    @Override
    public final void putColumnValuesInMapOfNames(Map<String, List<String>> map) {
        this.splitter.putColumnValuesInMapOfNames(map);
    }

    @Override
    public final void putColumnValuesInMapOfIndexes(Map<Integer, List<String>> map) {
        this.splitter.putColumnValuesInMapOfIndexes(map);
    }

    @Override
    public final Map<String, List<String>> getColumnValuesAsMapOfNames() {
        return this.splitter.getColumnValuesAsMapOfNames();
    }

    @Override
    public final Map<Integer, List<String>> getColumnValuesAsMapOfIndexes() {
        return this.splitter.getColumnValuesAsMapOfIndexes();
    }

    @Override
    public int getRowsPerBatch() {
        return this.rowsPerBatch;
    }

    @Override
    public int getBatchesProcessed() {
        return this.batchesProcessed;
    }

    @Override
    public abstract void batchProcessed(int var1);
}

