% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{spark_write_csv}
\alias{spark_write_csv}
\title{Write a Spark DataFrame to a CSV}
\usage{
spark_write_csv(x, path, header = TRUE, delimiter = ",", quote = "\\"",
  escape = "\\\\", charset = "UTF-8", null_value = NULL,
  options = list())
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3n://"} and \samp{"file://"} protocols.}

\item{header}{Should the first row of data be used as a header? Defaults to \code{TRUE}.}

\item{delimiter}{The character used to delimit each column, defaults to \code{,}.}

\item{quote}{The character used as a quote, defaults to \code{"hdfs://"}.}

\item{escape}{The chatacter used to escape other characters, defaults to \code{\\}.}

\item{charset}{The character set, defaults to \code{"UTF-8"}.}

\item{null_value}{The character to use for default values, defaults to \code{NULL}.}

\item{options}{A list of strings with additional options.}
}
\description{
Write a Spark DataFrame to a tabular (typically, comma-separated) file.
}
\seealso{
Other Spark serialization routines: \code{\link{spark_load_table}},
  \code{\link{spark_read_csv}},
  \code{\link{spark_read_json}},
  \code{\link{spark_read_parquet}},
  \code{\link{spark_save_table}},
  \code{\link{spark_write_json}},
  \code{\link{spark_write_parquet}}
}

