\name{SpawAggregateOutput-class}
\Rdversion{1.1}
\docType{class}
\alias{SpawAggregateOutput-class}
\alias{[,SpawAggregateOutput,ANY,ANY,ANY-method}
\alias{getSample,SpawAggregateOutput-method}
\alias{length,SpawAggregateOutput-method}
\alias{merge,SpawAggregateOutput,SpawAggregateOutput-method}
\alias{names<-,SpawAggregateOutput-method}
\alias{names<-,SpawAggregateOutput,ANY-method}
\alias{names,SpawAggregateOutput-method}
\alias{show,SpawAggregateOutput-method}

\title{Class \code{"SpawAggregateOutput"}}
\description{
%%  ~~ A concise (1-5 lines) description of what the class is. ~~
  Output object of the function \code{SpawAggregate}.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("SpawAggregateOutput", ...)}.
%%  ~~ describe objects here ~~ 
}
\section{Slots}{
  \describe{
    \item{\code{seed}:}{Object of class \code{"ANY"} ~~ }

    contains the random seed which was used in \code{SpawAggregate}.
    Use this seed if you want to reproduce the same resamples.
    
    \item{\code{aggregated.samples}:}{Object of class \code{"list"} ~~ }
        
    A \code{list} of matrices of dimension \eqn{n\times m}{n by m} where \eqn{n} 
    is the number of contextual units and \eqn{m} is the number of resamples containing
    the aggregated context data for each resample.
    
    \item{\code{frames}:}{Object of class \code{"list"} ~~ }

    A \code{list} of \code{data.frame}s. One \code{data.frame} per
    contextual name, each containing the mean estimate, standard
    deviation, median and confidence intervals of the corresponding
    contextual variable by contextual unit.
  }
}
\section{Methods}{
  \describe{
    \item{merge}{
      \code{signature(x = "SpawAggregateOutput", y =
        "SpawAggregateOutput")}:
      Merges \code{SpawAggregateOutput} objects. This is useful if
    contextual data is being aggregated from different individual level
    data bases.
    }
    \item{[}{\code{signature(x = "SpawAggregateOutput", i = "ANY", j =
        "ANY", drop = "ANY")}: Allows to extract the dataframe corresponding to a bootstrap sample.}
    
    
    
    \item{getSample}{\code{signature(object = "SpawAggregateOutput")}:
     Also allows to extract the dataframe corresponding to a bootstrap sample.}
    
    
    
    \item{length}{\code{signature(x = "SpawAggregateOutput")}: Returns the number of bootstrap samples contained in the object. }
    
    \item{names}{\code{signature(x = "SpawAggregateOutput")}:    Returns the names of aggregated variables in the object
}
    \item{names<-}{\code{signature(x = "SpawAggregateOutput")}:     Allows to assign names to the aggregates in the object }

    \item{names<-}{\code{signature(x = "SpawAggregateOutput", NA =
        "ANY")}: Allows to change names to the aggregated variables in the object. }
    
    \item{show}{\code{signature(object = "SpawAggregateOutput")}: Prints a meaningful short description of the object. }
    
	 }
}
%\references{
%%%  ~~put references to the literature/web site here~~
%}
\author{
Till Junge, Sandra Penic, Guy Elcheroth
}
%\note{
%%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
is generated by \code{\link{SpawAggregate}}
}
\examples{
## load distance matrix
data(d_geo)
## create a weight matrix
geow.50 <- WeightMatrix(d_geo, bandwidth=50)
## load contextual data
data(traces_event)

## aggregate data
\dontshow{traces_event=traces_event[seq(1, nrow(traces_event), by=100),]}
wv.int <- SpawAggregate(contextual.data=traces_event,
                        context.id="area.name",
                        contextual.names=c("w_all", "w_all"),
                        contextual.weight.matrices=list(NULL, geow.50),
                        aggregation.functions="weighted.mean",
                        design.weight.names="weight",
                        nb.resamples=4)
## check the number of samples
length(wv.int)

## check the second sample
head(wv.int[2])

## change the names of the weighted indicators to more significant ones
names(wv.int) <- c("w_all.0", "w_all.50")

showClass("SpawAggregateOutput")
}
\keyword{classes}
\keyword{spatial}