% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formants.R
\name{estimateVTL}
\alias{estimateVTL}
\title{Estimate vocal tract length}
\usage{
estimateVTL(formants, speedSound = 35400, checkFormat = TRUE)
}
\arguments{
\item{formants}{a character string like "aaui" referring to default presets
for speaker "M1"; a vector of formant frequencies; or a list of formant
times, frequencies, amplitudes, and bandwidths, with a single value of each
for static or multiple values of each for moving formants.}

\item{speedSound}{speed of sound in warm air, cm/s. Stevens (2000) "Acoustic
phonetics", p. 138}

\item{checkFormat}{if TRUE, expands shorthand format specifications into the
canonical form of a list with four components: time, frequency, amplitude
and bandwidth for each format (as returned by the internal function
\code{reformatFormants})}
}
\value{
Returns the estimated vocal tract length in cm.
}
\description{
Estimates the length of vocal tract based on formant frequencies, assuming
that the vocal tract can be modeled as a tube open as both ends.
}
\examples{
estimateVTL(NA)
estimateVTL(500)
estimateVTL(c(600, 1850, 3100))
estimateVTL(formants = list(f1 = 600, f2 = 1650, f3 = 2400))

# for moving formants, frequencies are averaged over time,
# i.e. this is identical to the previous example
estimateVTL(formants = list(f1 = c(500, 700), f2 = 1650, f3 = c(2200, 2600)))
}
