% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{clumper}
\alias{clumper}
\title{Clump a sequence into large segments}
\usage{
clumper(s, minLength)
}
\arguments{
\item{s}{a vector (soundgen supplies integers, but \code{clumper} also works
on a vector of floats, characters or booleans)}

\item{minLength}{an integer or vector of integers indicating the desired
length of a segment at each position (can vary with time, e.g., if we are
processing pitch_per_gc values)}
}
\value{
Returns the original sequence s transformed to homogeneous segments
  of required length.
}
\description{
Internal soundgen function.
}
\details{
\code{clumper} makes sure each homogeneous segment in a sequence is at least
minLength long. Called by getIntegerRandomWalk() and getVocalFry(). Algorithm:
go through the sequence once. If a short segment is encountered, it is pooled
with the previous one (i.e., the currently evaluated segment grows until it
is long enough, which may shorten the following segment). Finally, the last
segment is checked separately. This is CRUDE - a smart implementation is
pending!
}
\examples{
s = c(1,3,2,2,2,0,0,4,4,1,1,1,1,1,3,3)
soundgen:::clumper(s, 2)
soundgen:::clumper(s, 3)
soundgen:::clumper(s, seq(1, 3, length.out = length(s)))
soundgen:::clumper(c('a','a','a','b','b','c','c','c','a','c'), 4)
}
\keyword{internal}
